/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.util.Enums2;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum SearchContext {
    ENTIRE_PLATFORM{

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visitEntirePlatform();
        }
    }
    ,
    ENTITY_AND_SUBENTITIES{

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visitEntityAndSubEntities();
        }
    }
    ,
    ENTITY{

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visitEntity();
        }
    }
    ,
    MY_CONTENT{

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visitMyContent();
        }
    }
    ,
    ADMIN{

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visitAdmin();
        }
    }
    ,
    MEMBER{

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visitMember();
        }
    }
    ,
    SUBSCRIPTION{

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visitSubscription();
        }
    };

    private static final ImmutableMap<String, SearchContext> BY_NAME;
    private static final ImmutableSet<SearchContext> MY_CONTENT_SEARCH_CONTEXTS;

    @CheckForNull
    public static SearchContext getByName(@Nullable String name) {
        return (SearchContext)((Object)BY_NAME.get((Object)name));
    }

    public boolean isGlobal() {
        return this != ENTITY && this != ENTITY_AND_SUBENTITIES;
    }

    public boolean isMyContentContext() {
        return MY_CONTENT_SEARCH_CONTEXTS.contains((Object)this);
    }

    @Nonnull
    public abstract <R> R accept(@Nonnull Visitor<R> var1);

    static {
        BY_NAME = Enums2.index((Enum[])SearchContext.values());
        MY_CONTENT_SEARCH_CONTEXTS = ImmutableSet.of((Object)((Object)MY_CONTENT), (Object)((Object)ADMIN), (Object)((Object)MEMBER), (Object)((Object)SUBSCRIPTION));
    }

    public static abstract class VisitorFunction<T>
    extends NullPermeableFunction<SearchContext, T>
    implements Visitor<T> {
        @Override
        protected T applySafe(SearchContext input) {
            return (T)input.accept(this);
        }
    }

    public static interface Visitor<R> {
        @Nonnull
        public R visitEntirePlatform();

        @Nonnull
        public R visitSubscription();

        @Nonnull
        public R visitMember();

        @Nonnull
        public R visitAdmin();

        @Nonnull
        public R visitMyContent();

        @Nonnull
        public R visitEntity();

        @Nonnull
        public R visitEntityAndSubEntities();
    }
}

