/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileAttributeSearchFacet
implements SearchFacet {
    private static final long serialVersionUID = 1L;
    private String _name;

    @Deprecated
    public ProfileAttributeSearchFacet() {
    }

    public ProfileAttributeSearchFacet(String name) {
        this._name = name;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Override
    public Predicate<FilterType> applyForFilterType(SearchConfigurationProvider searchConfigurationProvider) {
        return Predicates.equalTo((Object)StaticFilterType.PROFILES);
    }

    @Override
    public boolean applyWithoutFilterType(SearchConfigurationProvider searchConfigurationProvider) {
        return false;
    }

    @Override
    public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
        return visitor.visitProfileAttribute(this);
    }

    @Override
    public String getFacetName() {
        return "profile_facet_dynamic_" + this.getName();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getName()});
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof ProfileAttributeSearchFacet && Objects.equal((Object)this.getName(), (Object)((ProfileAttributeSearchFacet)obj).getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).toString();
    }
}

