/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.shared.model.BadgeField;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.person.shared.model.PersonType;
import de.justsoftware.onx.searchnew.shared.model.SearchSuggestModelVisitor;
import de.justsoftware.onx.searchnew.shared.model.SuggestModel;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PersonSuggest
extends SuggestModel<PersonId, PersonType> {
    private static final long serialVersionUID = 1L;
    private boolean _blocked;
    private boolean _active;
    private Date _modifyDate;
    private ImmutableList<BadgeField> _visibleFields = ImmutableList.of();

    @Override
    public <T> T visit(SearchSuggestModelVisitor<T> visitor) {
        return visitor.visitPerson(this);
    }

    public void setBlocked(boolean blocked) {
        this._blocked = blocked;
    }

    public boolean isBlocked() {
        return this._blocked;
    }

    public boolean isActive() {
        return this._active;
    }

    public void setActive(boolean active) {
        this._active = active;
    }

    public void setModifyDate(@Nullable Date modifyDate) {
        this._modifyDate = Dates.clone(modifyDate);
    }

    @CheckForNull
    public Date getModifyDate() {
        return Dates.clone(this._modifyDate);
    }

    @Nonnull
    public ImmutableList<BadgeField> getVisibleFields() {
        return this._visibleFields;
    }

    public void setVisibleFields(ImmutableList<BadgeField> visibleFields) {
        this._visibleFields = visibleFields;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringBuilder() {
        return super.toStringBuilder().add("blocked", this._blocked).add("active", this._active).add("modifyDate", (Object)this._modifyDate);
    }
}

