/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.util.ValueOfMap;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.shared.model.EntityFilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeVisitor;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FilterTypes {
    public static final Function<FilterType, String> TO_NAME = input -> input == null ? null : input.getName();
    public static final Function<FilterType, Type> TO_TYPE = input -> input != null ? input.getType() : null;
    public static final Function<FilterType, String> TO_TYPE_NAME = input -> input == null ? null : input.getType().name();
    public static final Function<String, FilterType> VALUE_OF_FUNCTION = FilterTypes::valueOf;
    public static final Function<Type, FilterType> GET_BY_TYPE = FilterTypes::getByType;
    public static final Function<FilterType, EntityType> TO_ENTITY_TYPE = new FilterTypeVisitor.OptionalFilterTypeVisitorFunction<EntityType>(){

        @Override
        public Optional<EntityType> visitEntity(EntityType entityType) {
            return Optional.of((Object)entityType);
        }
    };
    private static final ValueOfMap<Type, Optional<? extends FilterType>> BY_TYPE = new ValueOfMap<Type, Optional<? extends FilterType>>(){
        {
            for (StaticFilterType filter : StaticFilterType.values()) {
                this.put(filter.getType(), Optional.of((Object)filter));
            }
        }

        @Override
        protected Optional<? extends FilterType> create(Type type) {
            return type instanceof EntityType ? Optional.of((Object)new EntityFilterType((EntityType)type)) : Optional.absent();
        }
    };
    private static final ValueOfMap<String, Optional<? extends FilterType>> BY_NAME = new ValueOfMap<String, Optional<? extends FilterType>>(){
        {
            for (StaticFilterType filter : StaticFilterType.values()) {
                this.put(filter.getName(), Optional.of((Object)filter));
            }
            this.put("-1", Optional.of((Object)StaticFilterType.ALL));
            this.put("0", Optional.of((Object)StaticFilterType.PROFILES));
            this.put("1", BY_TYPE.get(EntityType.NETWORK));
            this.put("2", BY_TYPE.get(EntityType.GROUP));
            this.put("3", BY_TYPE.get(EntityType.WIKI));
            this.put("4", BY_TYPE.get(EntityType.APPOINTMENT));
            this.put("5", BY_TYPE.get(EntityType.PUBLICATION));
            this.put("6", Optional.of((Object)StaticFilterType.DOCUMENTS));
            this.put("8", BY_TYPE.get(EntityType.TOPIC));
            this.put("9", BY_TYPE.get(EntityType.ARTICLE));
            this.put("10", BY_TYPE.get(EntityType.PARTNERSITE));
            this.put("NETWORKS", BY_TYPE.get(EntityType.NETWORK));
            this.put("GROUPS", BY_TYPE.get(EntityType.GROUP));
            this.put("WIKI", BY_TYPE.get(EntityType.WIKI));
            this.put("APPOINTMENTS", BY_TYPE.get(EntityType.APPOINTMENT));
            this.put("PUBLICATIONS", BY_TYPE.get(EntityType.PUBLICATION));
            this.put("TOPICS", BY_TYPE.get(EntityType.TOPIC));
            this.put("ARTICLES", BY_TYPE.get(EntityType.ARTICLE));
            this.put("PARTNERSITES", BY_TYPE.get(EntityType.PARTNERSITE));
        }

        @Override
        protected Optional<? extends FilterType> create(String s) {
            if (!s.startsWith("ENTITY_")) {
                return Optional.absent();
            }
            return BY_TYPE.get(EntityType.valueOf(s.substring("ENTITY_".length())));
        }
    };
    private static final ValueOfMap<String, FilterType> BY_TYPE_NAME = new ValueOfMap<String, FilterType>(){
        {
            this.putAll(Maps.uniqueIndex((Iterator)Iterators.forArray((Object[])StaticFilterType.values()), TO_TYPE_NAME));
        }

        @Override
        protected FilterType create(String s) {
            return FilterTypes.getByEntityType(EntityType.valueOf(s));
        }
    };

    private FilterTypes() {
    }

    @CheckForNull
    public static FilterType valueOf(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return (FilterType)BY_NAME.get(s).orNull();
    }

    @Nonnull
    public static FilterType getByEntityType(@Nonnull EntityType entityType) {
        return (FilterType)BY_TYPE.get(entityType).get();
    }

    @CheckForNull
    public static FilterType getByType(@Nullable Type type) {
        if (type == null) {
            return null;
        }
        return (FilterType)BY_TYPE.get(type).orNull();
    }

    @CheckForNull
    public static FilterType getByTypeName(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return BY_TYPE_NAME.get(s);
    }
}

