/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.Nonnull;

public interface FilterTypeVisitor<T> {
    @Nonnull
    public T visitDefault();

    @Nonnull
    default public T visitAll() {
        return this.visitDefault();
    }

    @Nonnull
    default public T visitNewsPosts() {
        return this.visitDefault();
    }

    @Nonnull
    default public T visitNewsChannels() {
        return this.visitDefault();
    }

    @Nonnull
    default public T visitProfiles() {
        return this.visitDefault();
    }

    @Nonnull
    default public T visitEntity(@Nonnull EntityType entityType) {
        return this.visitDefault();
    }

    @Nonnull
    default public T visitMicroblogs() {
        return this.visitDefault();
    }

    @Nonnull
    default public T visitChats() {
        return this.visitDefault();
    }

    @Nonnull
    default public T visitDocuments() {
        return this.visitDefault();
    }

    @Nonnull
    default public T visitWiki() {
        return this.visitDefault();
    }

    @Nonnull
    default public T visitChapter() {
        return this.visitDefault();
    }

    @Nonnull
    default public T visitArticle() {
        return this.visitDefault();
    }

    public static abstract class OptionalFilterTypeVisitorFunction<T>
    extends NullPermeableFunction<FilterType, T>
    implements FilterTypeVisitor<Optional<T>> {
        @Override
        public T applySafe(FilterType input) {
            return (T)((Optional)input.accept(this)).orNull();
        }

        @Override
        public Optional<T> visitDefault() {
            return Optional.absent();
        }
    }

    public static abstract class FilterTypeVisitorFunction<T>
    extends NullPermeableFunction<FilterType, T>
    implements FilterTypeVisitor<T> {
        @Override
        public T applySafe(FilterType input) {
            return input.accept(this);
        }
    }

    public static abstract class FilterTypeVisitorPredicate
    implements Predicate<FilterType>,
    FilterTypeVisitor<Boolean> {
        public final boolean apply(FilterType input) {
            return input != null && input.accept(this) != false;
        }
    }
}

