/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.shared.model.MultiSelectSubfilter;
import de.justsoftware.onx.searchnew.shared.model.SubFilterVisitor;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityDynamicAttributeSubFilter
implements MultiSelectSubfilter<String> {
    private static final long serialVersionUID = 1L;
    private DynamicAttributeId _attributeId;
    private ImmutableSet<String> _values;
    private EntityType _entityType;

    @Deprecated
    public EntityDynamicAttributeSubFilter() {
    }

    public EntityDynamicAttributeSubFilter(DynamicAttributeId attributeId, EntityType entityType, ImmutableSet<String> values) {
        this._attributeId = attributeId;
        this._entityType = entityType;
        this._values = values;
    }

    @Nonnull
    public DynamicAttributeId getAttributeId() {
        return this._attributeId;
    }

    @Override
    public ImmutableSet<String> getFilterValues() {
        return this._values;
    }

    @Nonnull
    public EntityType getEntityType() {
        return this._entityType;
    }

    @Override
    public <T> T accept(SubFilterVisitor<T> visitor) {
        return visitor.visitEntityDynamicAttributeSubFilter(this);
    }

    @Nonnull
    public static Predicate<EntityDynamicAttributeSubFilter> attributeIdEqualsPredicate(final DynamicAttributeId attributeId) {
        return new NullIsFalsePredicate<EntityDynamicAttributeSubFilter>(){

            @Override
            protected boolean applySafe(EntityDynamicAttributeSubFilter input) {
                return Objects.equal((Object)input.getAttributeId(), (Object)attributeId);
            }
        };
    }

    public int hashCode() {
        return Arrays.hashCode(this.hashObjects());
    }

    @Nonnull
    private Object[] hashObjects() {
        return new Object[]{this._attributeId, this._entityType, this._values};
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof EntityDynamicAttributeSubFilter && Arrays.equals(this.hashObjects(), ((EntityDynamicAttributeSubFilter)obj).hashObjects());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attributeId", (Object)this._attributeId).add("entityType", (Object)this._entityType).add("values", this._values).toString();
    }
}

