/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.util.Dates;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.solr.client.solrj.beans.Field;

public class CommonSearchModel
implements Serializable {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String NAME_SUBSTRING = "name_substring";
    public static final String TAGS = "tags";
    public static final String TAGS_FOR_FACET_SEARCH = "tags_for_facet_search";
    public static final String TYPE = "type";
    public static final String VISIBLE_FOR_ROLES = "visible_for_roles";
    public static final String VISIBLE_FOR_PERSONS = "visible_for_persons";
    public static final String VISIBILITY_INCLUDED_ITEM_DEPENDANT_ROLES = "visibility_included_item_dependant_roles";
    public static final String ENTITY_DYNAMIC_PREFIX = "entity_dynamic_";
    public static final String ENTITY_FACET_DYNAMIC_PREFIX = "entity_facet_dynamic_";
    public static final String ENTITY_DYNAMIC_WILDCARD = "entity_dynamic_*";
    public static final String ENTITY_FACET_DYNAMIC_WILDCARD = "entity_facet_dynamic_*";
    public static final String MULTIWIKI_FOR_ROLE_PREFIX = "multiwiki_for_role_";
    public static final String MULTIWIKI_FOR_ROLE_WILDCARD = "multiwiki_for_role_*";
    public static final String FILETYPE_ID = "file_type_id";
    public static final String URL_LINKS = "url_links";
    public static final String URL_LABELS = "url_labels";
    public static final String FIRSTNAME = "firstname";
    public static final String LASTNAME = "lastname";
    public static final String NAME_SORT = "name_sort";
    public static final String BIRTHDAY = "birthday";
    public static final String ROLES = "roles";
    public static final String ROLES_NOT_HIDDEN = "roles_not_hidden";
    public static final String BLOCKED = "blocked";
    public static final String CHAT_USER = "chat_user";
    public static final String PROFILE_DYNAMIC_PREFIX = "profile_dynamic_";
    public static final String PROFILE_FACET_DYNAMIC_PREFIX = "profile_facet_dynamic_";
    public static final String PROFILE_DYNAMIC_WILDCARD = "profile_dynamic_*";
    public static final String DESCRIPTION = "description";
    public static final String LOCATION = "location";
    public static final String START_DATE = "start_date";
    public static final String END_DATE = "end_date";
    public static final String CONTENT = "content";
    public static final String AUTHOR = "author";
    public static final String COMMENTS = "comments";
    public static final String PARENT_IDS = "parent_ids";
    public static final String PARENT_NAME = "parent_name";
    public static final String DIRECT_PARENT_IDS = "direct_parent_ids";
    public static final String PATH = "path";
    public static final String MODIFY_DATE = "modify_date";
    public static final String PUBLICATION_DATE = "publication_date";
    public static final String EXPIRATION_DATE = "expiration_date";
    public static final String MEMBER_IDS = "member_ids";
    public static final String DIRECT_MEMBER_IDS = "direct_member_ids";
    public static final String INHERIT_MEMBER_IDS = "inherit_member_ids";
    public static final String ADMIN_IDS = "admin_ids";
    public static final String DIRECT_ADMIN_IDS = "direct_admin_ids";
    public static final String INHERIT_ADMIN_IDS = "inherit_admin_ids";
    public static final String SUBSCRIBER_IDS = "subscriber_ids";
    public static final String MY_CONTENT_PERSON_IDS = "my_content_person_ids";
    public static final String USER_CONTENT_PERSON_IDS = "user_content_person_ids";
    public static final String ENTITY_FACET_STATUS = "entity_facet_status";
    public static final String ENTITY_FACET_ASSIGNEE = "entity_facet_assignee";
    public static final String PARTICIPANTS = "participants";
    public static final String CHAT_TYPE = "chat_type";
    public static final String DRIVE_SPECIFIC_FIELDS_WILDCARD = "drive_*";
    public static final String DRIVE_DOCUMENT_TYPE = "drive_document_type";
    public static final String DRIVE_FILE_SIZE = "drive_file_size";
    public static final String DRIVE_FILE_TYPE = "drive_file_type";
    private static final long serialVersionUID = 4L;
    @Field(value="parent_ids")
    private List<String> _parentIds;
    @Field(value="parent_name")
    private String _parentName;
    @Field(value="direct_parent_ids")
    private Iterable<String> _directParentIds;
    @Field(value="direct_member_ids")
    private List<String> _directMemberIds;
    @Field(value="inherit_member_ids")
    private List<String> _inheritMemberIds;
    @Field(value="direct_admin_ids")
    private List<String> _directAdminIds;
    @Field(value="inherit_admin_ids")
    private List<String> _inheritAdminIds;
    @Field(value="subscriber_ids")
    private List<String> _subscriberIds;
    @Field(value="modify_date")
    private Date _modifyDate;
    @Field(value="publication_date")
    private Date _publicationDate;
    @Field(value="expiration_date")
    private Date _expirationDate;
    @Field(value="description")
    private String _description;
    @Field(value="start_date")
    private Date _startDate;
    @Field(value="end_date")
    private Date _endDate;
    @Field(value="location")
    private String _location;
    @Field(value="content")
    private List<String> _content;
    @Field(value="author")
    private String _author;
    @Field(value="comments")
    private List<String> _comments;
    @Field(value="id")
    private String _id;
    @Field(value="name")
    private String _name;
    @Field(value="tags")
    private Iterable<String> _tags;
    @Field(value="type")
    private String _type;
    @Field(value="visible_for_roles")
    private List<String> _visibleForRoles;
    @Field(value="visible_for_persons")
    private List<Long> _visibleForPersons;
    @Field(value="visibility_included_item_dependant_roles")
    private List<String> _visibilityIncludedItemDependantRoles;
    @Field(value="profile_dynamic_*")
    private Map<String, Collection<String>> _dynamicProfileAttributes = Maps.newHashMap();
    @Field(value="entity_dynamic_*")
    private Map<String, Collection<String>> _dynamicEntityAttributes = Maps.newHashMap();
    @Field(value="entity_facet_dynamic_*")
    private Map<String, Collection<String>> _dynamicEntityAttributeFacets;
    @Field(value="entity_facet_status")
    private Long _entityFacetStatus;
    @Field(value="entity_facet_assignee")
    private Long _entityFacetAssignee;
    @Field(value="participants")
    private List<String> _participants;
    @Field(value="file_type_id")
    private Long _fileTypeId;
    @Field(value="firstname")
    private String _firstName;
    @Field(value="lastname")
    private String _lastName;
    @Field(value="name_sort")
    private String _nameSort;
    @Field(value="birthday")
    private Date _birthday;
    @Field(value="blocked")
    private Boolean _blocked;
    @Field(value="roles")
    private Iterable<String> _roles;
    @Field(value="multiwiki_for_role_*")
    private Map<String, Collection<String>> _multiwikiForRole = Maps.newHashMap();
    @Field(value="url_links")
    private Iterable<String> _urlLinks;
    @Field(value="url_labels")
    private Iterable<String> _urlLabels;
    @Field(value="chat_type")
    private String _chatType;
    @Field(value="drive_*")
    private Map<String, Collection<String>> _driveSpecificFields;
    @Field(value="drive_file_size")
    private long _driveFileSize;
    @Field(value="drive_file_type")
    private String _driveFileType;

    @Nonnull
    public Map<String, Collection<String>> getMultiwikiForRole() {
        return this._multiwikiForRole;
    }

    public void setMultiwikiForRole(@Nonnull Map<String, Collection<String>> multiwikiForRole) {
        this._multiwikiForRole = multiwikiForRole;
    }

    public List<String> getVisibilityIncludedItemDependantRoles() {
        return this._visibilityIncludedItemDependantRoles;
    }

    public void setVisibilityIncludedItemDependantRoles(List<String> visibilityIncludeItemDependantRoles) {
        this._visibilityIncludedItemDependantRoles = visibilityIncludeItemDependantRoles;
    }

    public List<String> getParentIds() {
        return this._parentIds;
    }

    public void setParentIds(List<String> parentIds) {
        this._parentIds = parentIds;
    }

    public Iterable<String> getDirectParentIds() {
        return this._directParentIds;
    }

    public void setDirectParentIds(Iterable<String> directParentIds) {
        this._directParentIds = directParentIds;
    }

    public Date getModifyDate() {
        return Dates.clone(this._modifyDate);
    }

    public void setModifyDate(Date modifyDate) {
        this._modifyDate = Dates.clone(modifyDate);
    }

    @CheckForNull
    public Date getPublicationDate() {
        return Dates.clone(this._publicationDate);
    }

    public void setPublicationDate(@Nullable Date publicationDate) {
        this._publicationDate = Dates.clone(publicationDate);
    }

    @CheckForNull
    public Date getExpirationDate() {
        return Dates.clone(this._expirationDate);
    }

    public void setExpirationDate(@Nullable Date expirationDate) {
        this._expirationDate = Dates.clone(expirationDate);
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public Date getStartDate() {
        return Dates.clone(this._startDate);
    }

    public void setStartDate(Date startDate) {
        this._startDate = Dates.clone(startDate);
    }

    public Date getEndDate() {
        return Dates.clone(this._endDate);
    }

    public void setEndDate(Date endDate) {
        this._endDate = Dates.clone(endDate);
    }

    public String getLocation() {
        return this._location;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public List<String> getContent() {
        return this._content;
    }

    public String getContentConcatenated() {
        return this._content != null ? Joiner.on((String)"\n").join(this._content) : null;
    }

    public void setContent(List<String> content) {
        this._content = content;
    }

    public String getAuthor() {
        return this._author;
    }

    public void setAuthor(String author) {
        this._author = author;
    }

    public List<String> getComments() {
        return this._comments;
    }

    public void setComments(List<String> comments) {
        this._comments = comments;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Iterable<String> getTags() {
        return this._tags;
    }

    public void setTags(Iterable<String> tags) {
        this._tags = tags;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public List<String> getVisibleForRoles() {
        return this._visibleForRoles;
    }

    public void setVisibleForRoles(List<String> visibleForRoles) {
        this._visibleForRoles = visibleForRoles;
    }

    public List<Long> getVisibleForPersons() {
        return this._visibleForPersons;
    }

    public void setVisibleForPersons(List<Long> visibleForPersons) {
        this._visibleForPersons = visibleForPersons;
    }

    public Long getFileTypeId() {
        return this._fileTypeId;
    }

    public void setFileTypeId(Long fileTypeId) {
        this._fileTypeId = fileTypeId;
    }

    public String getFirstName() {
        return this._firstName;
    }

    public void setFirstName(String firstName) {
        this._firstName = firstName;
    }

    public String getLastName() {
        return this._lastName;
    }

    public void setLastName(String lastName) {
        this._lastName = lastName;
    }

    public Date getBirthday() {
        return Dates.clone(this._birthday);
    }

    public void setBirthday(Date birthday) {
        this._birthday = Dates.clone(birthday);
    }

    @CheckForNull
    public Boolean isBlocked() {
        return this._blocked;
    }

    public void setBlocked(@Nullable Boolean blocked) {
        this._blocked = blocked;
    }

    public String getNameSort() {
        return this._nameSort;
    }

    public void setNameSort(String nameSort) {
        this._nameSort = nameSort;
    }

    @Nonnull
    public Map<String, Collection<String>> getDynamicProfileAttributes() {
        return this._dynamicProfileAttributes;
    }

    public void setDynamicProfileAttributes(@Nonnull Map<String, Collection<String>> dynamicProfileAttributes) {
        this._dynamicProfileAttributes = dynamicProfileAttributes;
    }

    @Nonnull
    public Map<String, Collection<String>> getDynamicEntityAttributes() {
        return this._dynamicEntityAttributes;
    }

    public void setDynamicEntityAttributes(@Nonnull Map<String, Collection<String>> dynamicEntityAttributes) {
        this._dynamicEntityAttributes = dynamicEntityAttributes;
    }

    @Nonnull
    public Map<String, Collection<String>> getDynamicEntityAttributeFacets() {
        return this._dynamicEntityAttributeFacets;
    }

    public void setDynamicEntityAttributeFacets(@Nonnull Map<String, Collection<String>> dynamicEntityAttributeFacets) {
        this._dynamicEntityAttributeFacets = dynamicEntityAttributeFacets;
    }

    @CheckForNull
    public Long getEntityFacetStatus() {
        return this._entityFacetStatus;
    }

    public void setEntityFacetStatus(@Nullable Long entityFacetStatus) {
        this._entityFacetStatus = entityFacetStatus;
    }

    @CheckForNull
    public Long getEntityFacetAssignee() {
        return this._entityFacetAssignee;
    }

    public void setEntityFacetAssignee(@Nullable Long entityFacetAssignee) {
        this._entityFacetAssignee = entityFacetAssignee;
    }

    @CheckForNull
    public List<String> getParticipants() {
        return this._participants;
    }

    public void setParticipants(@Nullable List<String> participants) {
        this._participants = participants;
    }

    public Iterable<String> getRoles() {
        return this._roles;
    }

    public void setRoles(Iterable<String> roles) {
        this._roles = roles;
    }

    public void setSubscriberIds(List<String> subscriberIds) {
        this._subscriberIds = subscriberIds;
    }

    public void setDirectAdminIds(List<String> directAdminIds) {
        this._directAdminIds = directAdminIds;
    }

    public void setInheritAdminIds(List<String> inheritAdminIds) {
        this._inheritAdminIds = inheritAdminIds;
    }

    public void setInheritMemberIds(List<String> inheritMemberIds) {
        this._inheritMemberIds = inheritMemberIds;
    }

    public void setDirectMemberIds(List<String> directMemberIds) {
        this._directMemberIds = directMemberIds;
    }

    public List<String> getInheritAdminIds() {
        return this._inheritAdminIds;
    }

    public List<String> getDirectAdminIds() {
        return this._directAdminIds;
    }

    public List<String> getInheritMemberIds() {
        return this._inheritMemberIds;
    }

    public List<String> getSubscriberIds() {
        return this._subscriberIds;
    }

    public List<String> getDirectMemberIds() {
        return this._directMemberIds;
    }

    @CheckForNull
    public Iterable<String> getUrlLinks() {
        return this._urlLinks;
    }

    public void setUrlLinks(@Nullable Iterable<String> urlLinks) {
        this._urlLinks = urlLinks;
    }

    @CheckForNull
    public Iterable<String> getUrlLabels() {
        return this._urlLabels;
    }

    public void setUrlLabels(@Nullable Iterable<String> urlLabels) {
        this._urlLabels = urlLabels;
    }

    @CheckForNull
    public String getChatType() {
        return this._chatType;
    }

    public void setChatType(@Nullable String chatType) {
        this._chatType = chatType;
    }

    @CheckForNull
    public Map<String, Collection<String>> getDriveSpecificFields() {
        return this._driveSpecificFields;
    }

    public void setDriveSpecificFields(@Nullable Map<String, Collection<String>> driveSpecificFields) {
        this._driveSpecificFields = driveSpecificFields;
    }

    public long getDriveFileSize() {
        return this._driveFileSize;
    }

    public void setDriveFileSize(long driveFileSize) {
        this._driveFileSize = driveFileSize;
    }

    @CheckForNull
    public String getParentName() {
        return this._parentName;
    }

    public void setParentName(String parentName) {
        this._parentName = parentName;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("parentIds", this._parentIds == null ? null : Integer.valueOf(this._parentIds.size())).add("directParentIds", this._directParentIds).add("directMemberIds", this._directMemberIds == null ? null : Integer.valueOf(this._directMemberIds.size())).add("inheritMemberIds", this._inheritMemberIds == null ? null : Integer.valueOf(this._inheritMemberIds.size())).add("directAdminIds", this._directAdminIds == null ? null : Integer.valueOf(this._directAdminIds.size())).add("inheritAdminIds", this._inheritAdminIds == null ? null : Integer.valueOf(this._inheritAdminIds.size())).add("subscriberIds", this._subscriberIds == null ? null : Integer.valueOf(this._subscriberIds.size())).add("modifyDate", (Object)this._modifyDate).add("publicationDate", (Object)this._publicationDate).add("expirationDate", (Object)this._expirationDate).add(DESCRIPTION, (Object)this._description).add("startDate", (Object)this._startDate).add("endDate", (Object)this._endDate).add(LOCATION, (Object)this._location).add(CONTENT, this._content).add(AUTHOR, (Object)this._author).add(COMMENTS, this._comments == null ? null : Integer.valueOf(this._comments.size())).add(ID, (Object)this._id).add(NAME, (Object)this._name).add(TAGS, this._tags).add(TYPE, (Object)this._type).add("visibleForRoles", this._visibleForRoles == null ? null : Integer.valueOf(this._visibleForRoles.size())).add("visibleForPersons", this._visibleForPersons == null ? null : Integer.valueOf(this._visibleForPersons.size())).add("visibilityIncludedItemDependantRoles", this._visibilityIncludedItemDependantRoles == null ? null : Integer.valueOf(this._visibilityIncludedItemDependantRoles.size())).add("dynamicProfileAttributes", this._dynamicProfileAttributes == null ? null : Integer.valueOf(this._dynamicProfileAttributes.size())).add("dynamicEntityAttributes", this._dynamicEntityAttributes == null ? null : Integer.valueOf(this._dynamicEntityAttributes.size())).add("dynamicEntityAttributeFacets", this._dynamicEntityAttributeFacets == null ? null : Integer.valueOf(this._dynamicEntityAttributeFacets.size())).add("entityFacetStatus", (Object)this._entityFacetStatus).add("entityFacetAssignee", (Object)this._entityFacetAssignee).add(PARTICIPANTS, this._participants == null ? null : Integer.valueOf(this._participants.size())).add("fileTypeId", (Object)this._fileTypeId).add("firstName", (Object)this._firstName).add("lastName", (Object)this._lastName).add("nameSort", (Object)this._nameSort).add(BIRTHDAY, (Object)this._birthday).add(BLOCKED, (Object)this._blocked).add(ROLES, this._roles).add("urlLinks", this._urlLinks).add("urlLabels", this._urlLabels).add("driveSpecificField", this._driveSpecificFields).add("driveFileSize", this._driveFileSize).toString();
    }
}

