/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class AbstractSearchConfigurationProvider
implements SearchConfigurationProvider {
    private final ImmutableSet<EntityType> _entityTypes;

    public AbstractSearchConfigurationProvider(ImmutableSet<EntityType> entityTypes) {
        this._entityTypes = entityTypes;
    }

    @Nonnull
    protected ImmutableSet<EntityType> getEntityTypes() {
        return this._entityTypes;
    }

    @Override
    public boolean isShowArchivedSearchFilterAnyEntityType() {
        for (EntityType type : this._entityTypes) {
            if (!this.isShowArchivedSearchFilter(type)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityTypes", this._entityTypes == null ? null : Integer.valueOf(this._entityTypes.size())).toString();
    }

    @Override
    public boolean isSortableByExpirationDate(EntityType entityType) {
        return entityType != null && !this.getEntityStatusByArchivedFlag(entityType).get((Object)Boolean.TRUE).isEmpty();
    }

    @Override
    public boolean isShowTagSearchFilterAnyFilterType() {
        if (this.isShowTagSearchFilterForDocuments()) {
            return true;
        }
        for (EntityType type : this._entityTypes) {
            if (!this.isShowTagSearchFilterForEntities(type)) continue;
            return true;
        }
        return false;
    }
}

