/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.integration.persistence.ibatis;

import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.searchnew.business.model.DBStoredSearchFilter;
import de.justsoftware.onx.searchnew.business.model.StoredSearchFilterId;
import de.justsoftware.onx.searchnew.integration.persistence.SearchFilterDAO;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class IbatisSearchFilterDAO
implements SearchFilterDAO {
    private final IbatisStatementBuilder _ibatisBuilder;

    @Autowired
    public IbatisSearchFilterDAO(StatementBuilderFactory statementBuilderFactory) {
        this._ibatisBuilder = statementBuilderFactory.ibatistStatementBuilder("SearchFilter");
    }

    @Override
    public ImmutableList<DBStoredSearchFilter> getStoredSearchFilterByPersonId(PersonId personId) {
        return ((IbatisStandardResultBuilder)this._ibatisBuilder.select("getStoredSearchFilterByPersonId").param("personId", personId)).asList();
    }

    @Override
    public void insertStoredSearchFilter(DBStoredSearchFilter searchFilter) {
        this._ibatisBuilder.insert("insertStoredSearchFilter").param(searchFilter);
    }

    @Override
    public void deleteStoredSearchFilter(StoredSearchFilterId searchFilterId) {
        this._ibatisBuilder.delete("deleteStoredSearchFilter").param(searchFilterId);
    }

    @Override
    public void deleteStoredSearchFilterByPersonId(PersonId personId) {
        this._ibatisBuilder.delete("deleteStoredSearchFilterByPersonId").param(personId);
    }

    @Override
    public DBStoredSearchFilter getStoredSearchFilterById(StoredSearchFilterId id) {
        return (DBStoredSearchFilter)this._ibatisBuilder.select("getStoredSearchFilterById").param(id).singleObject();
    }
}

