/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.model;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.searchnew.shared.model.MultiSelectSubfilter;
import de.justsoftware.onx.searchnew.shared.model.MultiSelectSubfilters;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@GwtIncompatible(value="Indirect usage of Class.isInstance")
public class SubFilterSet {
    private final FluentIterable<SubFilter> _subfilter;

    public SubFilterSet(Iterable<? extends SubFilter> subfilter) {
        this._subfilter = FluentIterable.from((Iterable)ImmutableSet.copyOf(subfilter));
    }

    @Nonnull
    public <T> ImmutableSet<T> getMultiSelectValues(Class<? extends MultiSelectSubfilter<T>> filterclass) {
        return (ImmutableSet)this._subfilter.filter(filterclass).first().transform(MultiSelectSubfilters.toSelectedFiltersFunction()).or((Object)ImmutableSet.of());
    }

    @Nonnull
    public <F extends MultiSelectSubfilter<T>, T> ImmutableSet<String> getMultiSelectValuesAsStrings(Class<F> filterclass, Function<? super T, String> valueToStringFunction) {
        return FluentIterable.from(this.getMultiSelectValues(filterclass)).transform(valueToStringFunction).toSet();
    }

    @Nonnull
    public <F extends MultiSelectSubfilter<T>, T> ImmutableSet<T> getMultiSelectValues(Class<F> filterclass, Predicate<? super F> filterSelector) {
        return (ImmutableSet)this._subfilter.filter(filterclass).firstMatch(filterSelector).transform(MultiSelectSubfilters.toSelectedFiltersFunction()).or((Object)ImmutableSet.of());
    }

    @Nonnull
    public <F extends MultiSelectSubfilter<T>, T> ImmutableSet<String> getMultiSelectValuesAsStrings(Class<F> filterclass, Predicate<? super F> filterSelector, Function<? super T, String> valueToStringFunction) {
        return FluentIterable.from(this.getMultiSelectValues(filterclass, filterSelector)).transform(valueToStringFunction).toSet();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("subfilter", this._subfilter).toString();
    }
}

