/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.searchnew.business.model.SearchLtrSearchResult;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchTrackingAction;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class SearchLtrSearchTrackingInfo {
    private final DateTime _timestamp;
    private final String _searchTrackingId;
    private final int _numberOfResults;
    private final int _offset;
    private final String _query;
    private final String _typeFilter;
    private final SearchContext _searchContext;
    private final String _searchContextId;
    private final ImmutableSet<String> _userRoles;
    private final ImmutableList<SearchLtrSearchResult> _results;

    public SearchLtrSearchTrackingInfo(DateTime timestamp, String searchTrackingId, SearchParameters searchParameters, int numberOfResults, int offset, Set<PersonRole> userRoles, List<SearchLtrSearchResult> results) {
        this._timestamp = timestamp;
        this._searchTrackingId = searchTrackingId;
        this._numberOfResults = numberOfResults;
        this._offset = offset;
        this._query = Strings.nullToEmpty((String)searchParameters.getText());
        this._typeFilter = searchParameters.getFilterTypeOrAll().getName();
        this._searchContext = searchParameters.getSearchContextOrEntirePlatform();
        GlobalId searchContextId = searchParameters.getContextId();
        this._searchContextId = searchContextId != null ? searchContextId.asString() : null;
        this._userRoles = (ImmutableSet)userRoles.stream().map(PersonRole::getName).collect(ImmutableSet.toImmutableSet());
        this._results = ImmutableList.copyOf(results);
    }

    @Nonnull
    public DateTime getTimestamp() {
        return this._timestamp;
    }

    @Nonnull
    public String getSearchTrackingId() {
        return this._searchTrackingId;
    }

    public int getNumberOfResults() {
        return this._numberOfResults;
    }

    public int getOffset() {
        return this._offset;
    }

    @Nonnull
    public String getQuery() {
        return this._query;
    }

    @Nonnull
    public String getTypeFilter() {
        return this._typeFilter;
    }

    @Nonnull
    public SearchContext getSearchContext() {
        return this._searchContext;
    }

    @CheckForNull
    public String getSearchContextId() {
        return this._searchContextId;
    }

    @Nonnull
    public ImmutableSet<String> getUserRoles() {
        return this._userRoles;
    }

    @Nonnull
    public ImmutableList<SearchLtrSearchResult> getResults() {
        return this._results;
    }

    @Nonnull
    public SearchTrackingAction getAction() {
        return SearchTrackingAction.USER_PERFORM_SEARCH;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("timestamp", (Object)this._timestamp).add("searchTrackingId", (Object)this._searchTrackingId).add("numberOfResults", this._numberOfResults).add("offset", this._offset).add("query", (Object)this._query).add("typeFilter", (Object)this._typeFilter).add("searchContext", (Object)this._searchContext).add("searchContextId", (Object)this._searchContextId).add("userRoles", this._userRoles).add("results", this._results).toString();
    }
}

