/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.model;

import javax.annotation.Nonnull;

public enum SearchIndexType {
    ALL(Visitor::visitAll),
    VISIBILITIES(Visitor::visitVisibilities),
    PARENTS(Visitor::visitParents),
    ENTITIES_MEMBERSHIP(Visitor::visitEntitiesMembership),
    ENTITIES_ADMIN(Visitor::visitEntitiesAdmin),
    COMMENTS(Visitor::visitComments),
    SUBSCRIBERS(Visitor::visitSubscribers),
    EXPIRATION(Visitor::visitExpiration),
    MODIFY_DATE(Visitor::visitModifyDate),
    PATH(Visitor::visitPath);

    private final Acceptor _acceptor;

    private SearchIndexType(Acceptor acceptor) {
        this._acceptor = acceptor;
    }

    @Nonnull
    public <T> T accept(@Nonnull Visitor<T> visitor) {
        return this._acceptor.accept(visitor);
    }

    @FunctionalInterface
    private static interface Acceptor {
        @Nonnull
        public <T> T accept(@Nonnull Visitor<T> var1);
    }

    public static interface Visitor<T> {
        @Nonnull
        public T visitAll();

        @Nonnull
        public T visitExpiration();

        @Nonnull
        public T visitSubscribers();

        @Nonnull
        public T visitComments();

        @Nonnull
        public T visitVisibilities();

        @Nonnull
        public T visitParents();

        @Nonnull
        public T visitEntitiesMembership();

        @Nonnull
        public T visitEntitiesAdmin();

        @Nonnull
        public T visitModifyDate();

        @Nonnull
        public T visitPath();
    }
}

