/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.model;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import de.justsoftware.onx.chat.shared.model.ChatId;
import de.justsoftware.onx.common.shared.model.LongId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.Teaser;
import de.justsoftware.onx.container.shared.model.AbstractUUIDBasedItemId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.NewsChannelId;
import de.justsoftware.onx.container.shared.model.NewsPostId;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchModel;
import de.justsoftware.onx.searchnew.shared.model.CompoundIdStringUtil;
import de.justsoftware.onx.wiki.shared.model.ArticleId;
import de.justsoftware.onx.wiki.shared.model.ChapterId;
import de.justsoftware.onx.wiki.shared.model.WikiId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class CompoundId {
    public static final Function<CommonSearchModel, CompoundId> FROM_COMMON_SEARCH_MODEL = new Function<CommonSearchModel, CompoundId>(){

        public CompoundId apply(CommonSearchModel input) {
            return input != null ? CompoundId.of(input) : null;
        }
    };
    public static final Function<PersonId, String> FROM_PERSON_ID_TO_SEARCH_STRING = Functions.compose(CompoundId::toSearchString, CompoundId::of);
    private final String _type;
    private final String _id;

    public CompoundId(@Nonnull String id, @Nonnull String type) {
        this._id = id;
        this._type = type;
    }

    public CompoundId(long id, @Nonnull String type) {
        this(String.valueOf(id), type);
    }

    @Nonnull
    public String getType() {
        return this._type;
    }

    @Nonnull
    public String getId() {
        return this._id;
    }

    @Nonnull
    public String toSearchString() {
        return CompoundIdStringUtil.getCompoundIdSearchString(this._id, this._type);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._id, this._type});
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof CompoundId && Objects.equal((Object)this._id, (Object)((CompoundId)obj)._id) && Objects.equal((Object)this._type, (Object)((CompoundId)obj)._type);
    }

    public static long parseLongId(@Nonnull String compoundId) {
        return Long.parseLong(CompoundIdStringUtil.parseStringId(compoundId));
    }

    public static UUID parseUUID(@Nonnull String compoundId) {
        return UUID.fromString(CompoundIdStringUtil.parseStringId(compoundId));
    }

    @Nonnull
    public static CompoundId parse(@Nonnull String compoundId) {
        return new CompoundId(CompoundIdStringUtil.parseStringId(compoundId), CompoundIdStringUtil.parseType(compoundId));
    }

    @CheckForNull
    public static <T extends ItemId> T parseToGlobalIdWithExpectedType(@Nonnull String compoundId, @Nonnull Class<T> expectedType) {
        ItemId itemId = CompoundId.parse(compoundId).toItemId();
        if (itemId != null && expectedType.isAssignableFrom(itemId.getClass())) {
            return (T)((ItemId)expectedType.cast(itemId));
        }
        return null;
    }

    @Nonnull
    public static CompoundId ofSearchableId(@Nonnull SearchableId id) {
        return id.accept(new SearchableId.Visitor<CompoundId>(){

            @Override
            public CompoundId visit(NewsPostId id) {
                return CompoundId.of(id);
            }

            @Override
            public CompoundId visit(NewsChannelId id) {
                return CompoundId.of(id);
            }

            @Override
            public CompoundId visit(PersonId personId) {
                return CompoundId.of(personId.asProfileId());
            }

            @Override
            public CompoundId visit(EntityId entityId) {
                return CompoundId.of(entityId);
            }

            @Override
            public CompoundId visit(WorkstreamMessageId workstreamMessageId) {
                return CompoundId.of(workstreamMessageId);
            }

            @Override
            public CompoundId visit(ConversationId conversationId) {
                return CompoundId.of(conversationId);
            }

            @Override
            public CompoundId visit(ChatId chatId) {
                return CompoundId.of(chatId);
            }

            @Override
            public CompoundId visit(DriveDocumentId driveDocumentId) {
                return CompoundId.of(driveDocumentId);
            }

            @Override
            public CompoundId visit(WikiId wikiId) {
                return CompoundId.of(wikiId);
            }

            @Override
            public CompoundId visit(ChapterId chapterId) {
                return CompoundId.of(chapterId);
            }

            @Override
            public CompoundId visit(ArticleId articleId) {
                return CompoundId.of(articleId);
            }
        });
    }

    @Nonnull
    public static CompoundId of(@Nonnull NewsPostId id) {
        return new CompoundId(id.getId(), id.getType().name());
    }

    @Nonnull
    public static CompoundId of(@Nonnull NewsChannelId id) {
        return new CompoundId(id.getId(), id.getType().name());
    }

    @Nonnull
    public static CompoundId of(@Nonnull GlobalId id) {
        return new CompoundId(String.valueOf(id.getId()), id.getType().name());
    }

    @Nonnull
    public static CompoundId of(@Nonnull AbstractUUIDBasedItemId id) {
        return new CompoundId(id.getId().toString(), id.getType().name());
    }

    @Nonnull
    public static CompoundId of(@Nonnull PersonId id) {
        return CompoundId.of(id.asProfileId());
    }

    @Nonnull
    public static CompoundId of(@Nonnull DriveDocumentId id) {
        return new CompoundId(id.getId(), id.getType().name());
    }

    @Nonnull
    public static CompoundId of(@Nonnull WikiId id) {
        return new CompoundId(id.getId(), "WIKI_WIKI");
    }

    @Nonnull
    public static CompoundId of(@Nonnull ChapterId id) {
        return new CompoundId(id.getId(), "WIKI_CHAPTER");
    }

    @Nonnull
    public static CompoundId of(@Nonnull ArticleId id) {
        return new CompoundId(id.getId(), "WIKI_ARTICLE");
    }

    @Nonnull
    public static CompoundId of(@Nonnull Teaser<? extends LongId, ?> teaser) {
        Object type = teaser.getType();
        if (type instanceof EntityType) {
            return new CompoundId(((LongId)teaser.getId()).getId(), ItemType.ENTITY.name());
        }
        return new CompoundId(((LongId)teaser.getId()).getId(), type.name());
    }

    @Nonnull
    public static CompoundId of(@Nonnull CommonSearchModel searchModel) {
        String compountId = searchModel.getId();
        CompoundId id = new CompoundId(CompoundIdStringUtil.parseStringId(compountId), CompoundIdStringUtil.parseType(compountId));
        return id;
    }

    @Nonnull
    public ItemId toItemId() {
        return ItemId.create(this.getItemType(), this._id);
    }

    @Nonnull
    private ItemType getItemType() {
        return ItemType.valueOf(this._type);
    }

    public String toString() {
        return this.toSearchString();
    }
}

