/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.searchnew.business.AdditionalData;
import de.justsoftware.onx.searchnew.business.AdditionalSuggestData;
import de.justsoftware.onx.searchnew.business.WorkstreamSearchHandler;
import de.justsoftware.onx.searchnew.business.impl.AbstractModuleSearchHandler;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchResultModel;
import de.justsoftware.onx.searchnew.shared.model.WorkstreamSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.WorkstreamSuggest;
import de.justsoftware.onx.workstream.business.WorkstreamService;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.attachments.Attachment;
import de.justsoftware.onx.workstream.shared.model.messages.DefaultWorkstreamMessageVisitor;
import de.justsoftware.onx.workstream.shared.model.messages.MicroblogPosting;
import de.justsoftware.onx.workstream.shared.model.messages.WorkstreamMessage;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkstreamSearchHandlerImpl
extends AbstractModuleSearchHandler<WorkstreamMessageId>
implements WorkstreamSearchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WorkstreamSearchHandlerImpl.class);
    private final WorkstreamService _workstreamService;
    private final ProfileTeaserService _profileTeaserService;

    @Autowired
    @ParametersAreNonnullByDefault
    public WorkstreamSearchHandlerImpl(EntityService entityService, ProfileTeaserService profileTeaserService, WorkstreamService workstreamService) {
        super(StaticComponentType.WORKSTREAM, entityService);
        this._profileTeaserService = profileTeaserService;
        this._workstreamService = workstreamService;
    }

    @Override
    protected WorkstreamMessageId createId(String stringId) {
        return new WorkstreamMessageId(CompoundId.parseLongId(stringId));
    }

    @Override
    public ImmutableMap<CompoundId, WorkstreamSearchResultBadgeModel> createSearchResultBadgeModel(Iterable<? extends CommonSearchResultModel> searchResultModel, AuthorizationCheckContextWithUserId authorizationContext) {
        if (Iterables.isEmpty(searchResultModel)) {
            return ImmutableMap.of();
        }
        AdditionalData.AdditionalWorkstreamData additionalData = this.loadBadgeData(searchResultModel, authorizationContext);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (CommonSearchResultModel commonSearchResultModel : searchResultModel) {
            WorkstreamSearchResultBadgeModel badge = WorkstreamSearchHandlerImpl.createSearchResultBadgeModel(commonSearchResultModel, additionalData);
            if (badge == null) continue;
            result.put((Object)CompoundId.of((GlobalId)badge.getId()), (Object)badge);
        }
        return result.build();
    }

    @CheckForNull
    private static WorkstreamSearchResultBadgeModel createSearchResultBadgeModel(@Nonnull CommonSearchResultModel searchResultModel, @Nonnull AdditionalData.AdditionalWorkstreamData additionalData) {
        DBWorkstreamMessage dbBean = (DBWorkstreamMessage)additionalData.getDBBeans().get(CompoundId.of(searchResultModel));
        if (dbBean == null) {
            LOG.warn("No db data found for " + searchResultModel.getId() + ". Skip it!");
            return null;
        }
        WorkstreamSearchResultBadgeModel searchBadge = new WorkstreamSearchResultBadgeModel();
        WorkstreamSearchHandlerImpl.initDBData(searchBadge, searchResultModel, dbBean, additionalData);
        searchBadge.setName(!Strings.isNullOrEmpty((String)searchResultModel.getName()) ? searchResultModel.getName() : searchResultModel.getContentConcatenated());
        searchBadge.setCommonFields(searchResultModel);
        searchBadge.setAuthor(additionalData.getProfiles().get(dbBean.getAuthorId().asPersonId()));
        searchBadge.setId(new WorkstreamMessageId(CompoundId.parseLongId(searchResultModel.getId())));
        WorkstreamSearchHandlerImpl.addFoundInData(searchBadge, searchResultModel, "... ");
        return searchBadge;
    }

    private static void initDBData(@Nonnull WorkstreamSearchResultBadgeModel searchBadge, @Nonnull CommonSearchResultModel searchResultModel, @Nullable DBWorkstreamMessage dbBean, @Nonnull AdditionalData.AdditionalWorkstreamData additionalData) {
        WorkstreamMessage message;
        ItemId dbOriginId;
        EntityInfo entityInfo;
        if (dbBean == null) {
            LOG.warn("No db data found for " + searchBadge.getName() + "(" + searchBadge.getId() + "). Skipping setting db data.");
            return;
        }
        EntityId parentId = WorkstreamSearchHandlerImpl.getIdOfNextEntityParent(searchResultModel);
        if (parentId != null && (entityInfo = additionalData.getParents().get(parentId)) != null) {
            searchBadge.setLinkedEntities((ImmutableList<EntityInfo>)ImmutableList.of((Object)entityInfo));
        }
        if ((dbOriginId = dbBean.getOriginItemId()) instanceof ProfileId) {
            ProfileId profileId = (ProfileId)dbOriginId;
            PersonTeaserModel personTeaser = additionalData.getProfiles().get(profileId.asPersonId());
            searchBadge.setLinkedProfile(personTeaser);
        }
        if ((message = additionalData.getWorkstreamMessages().get(dbBean.getId())) != null) {
            MicroblogPosting posting;
            searchBadge.setWorkstreamMessageType(message.getType());
            if (message instanceof MicroblogPosting && !Iterables.isEmpty((posting = (MicroblogPosting)message).getAttachments())) {
                searchBadge.setAttachments((Collection<Attachment>)posting.getAttachments());
            }
        }
    }

    private static void addFoundInData(@Nonnull WorkstreamSearchResultBadgeModel searchResultBadgeModel, @Nonnull CommonSearchResultModel searchResultModel, @Nonnull String delimiter) {
        WorkstreamSearchHandlerImpl.addFoundInField("content", searchResultBadgeModel, searchResultModel, delimiter);
        WorkstreamSearchHandlerImpl.addFoundInField("name", searchResultBadgeModel, searchResultModel, delimiter);
        WorkstreamSearchHandlerImpl.addFoundInField("comments", searchResultBadgeModel, searchResultModel, delimiter);
        WorkstreamSearchHandlerImpl.addFoundInField("url_links", searchResultBadgeModel, searchResultModel, delimiter);
        WorkstreamSearchHandlerImpl.addFoundInField("url_labels", searchResultBadgeModel, searchResultModel, delimiter);
    }

    @Nonnull
    private AdditionalData.AdditionalWorkstreamData loadBadgeData(@Nonnull Iterable<? extends CommonSearchResultModel> searchResultList, @Nonnull AuthorizationCheckContextWithUserId authorizationContext) {
        AdditionalSuggestData.AdditionalWorkstreamSuggestData suggestData = this.loadSuggestData(searchResultList, authorizationContext);
        Map dbBeans = suggestData.getDBBeans();
        if (dbBeans.isEmpty()) {
            return AdditionalData.AdditionalWorkstreamData.EMPTY;
        }
        ImmutableSet.Builder parentIds = ImmutableSet.builder();
        for (CommonSearchResultModel commonSearchResultModel : searchResultList) {
            EntityId parentId = WorkstreamSearchHandlerImpl.getIdOfNextEntityParent(commonSearchResultModel);
            if (parentId == null) continue;
            parentIds.add((Object)parentId);
        }
        ImmutableMap<EntityId, EntityInfo> parentMap = this._entityService.getInfoMapByIds((Set<EntityId>)parentIds.build(), authorizationContext);
        HashSet<PersonId> hashSet = new HashSet<PersonId>();
        for (DBWorkstreamMessage msg : dbBeans.values()) {
            ItemId originId = msg.getOriginItemId();
            if (originId instanceof ProfileId) {
                hashSet.add(((ProfileId)originId).asPersonId());
            }
            hashSet.add(msg.getAuthorId().asPersonId());
        }
        ImmutableMap<PersonId, PersonTeaserModel> profileMap = this._profileTeaserService.getPersonTeasersByIds(hashSet, authorizationContext);
        return new AdditionalData.AdditionalWorkstreamData(suggestData, (Map<EntityId, EntityInfo>)parentMap, (Map<PersonId, PersonTeaserModel>)profileMap);
    }

    @Override
    public ImmutableMap<CompoundId, WorkstreamSuggest> createSearchResultSuggestModel(Iterable<? extends CommonSearchResultModel> searchResultModel, AuthorizationCheckContextWithUserId authorizationContext) {
        if (Iterables.isEmpty(searchResultModel)) {
            return ImmutableMap.of();
        }
        AdditionalSuggestData.AdditionalWorkstreamSuggestData additionalData = this.loadSuggestData(searchResultModel, authorizationContext);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (CommonSearchResultModel commonSearchResultModel : searchResultModel) {
            WorkstreamSuggest suggest = this.createSearchResultSuggestModel(commonSearchResultModel, additionalData);
            if (suggest == null) continue;
            result.put((Object)CompoundId.of((GlobalId)suggest.getId()), (Object)suggest);
        }
        return result.build();
    }

    @CheckForNull
    private WorkstreamSuggest createSearchResultSuggestModel(@Nonnull CommonSearchResultModel searchResultModel, @Nonnull AdditionalSuggestData.AdditionalWorkstreamSuggestData additionalWorkstreamData) {
        final WorkstreamSuggest suggest = new WorkstreamSuggest();
        this.applySearchData(searchResultModel, this.getComponentType(), suggest);
        String title = searchResultModel.getName();
        suggest.setHtmlHighlightedName(!Strings.isNullOrEmpty((String)title) ? title : searchResultModel.getContentConcatenated());
        DBWorkstreamMessage dbWorkstreamMessage = (DBWorkstreamMessage)additionalWorkstreamData.getDBBeans().get(CompoundId.of(searchResultModel));
        if (dbWorkstreamMessage == null) {
            LOG.warn("No db data found for " + searchResultModel.getId() + ". Skip it!");
            return null;
        }
        WorkstreamMessage workstreamMessage = additionalWorkstreamData.getWorkstreamMessages().get(dbWorkstreamMessage.getId());
        if (workstreamMessage == null) {
            LOG.warn("No workstream message data found for " + searchResultModel.getId() + ". Skipping setting db data.");
            return suggest;
        }
        workstreamMessage.accept(new DefaultWorkstreamMessageVisitor<Object>(){

            @Override
            protected Object handleDefault(WorkstreamMessage m) {
                return this;
            }

            @Override
            public Object visitMicroblogPosting(MicroblogPosting m) {
                suggest.setName(m.getTitle() != null ? m.getTitle() : m.getText());
                return this;
            }
        });
        return suggest;
    }

    @Nonnull
    private AdditionalSuggestData.AdditionalWorkstreamSuggestData loadSuggestData(@Nonnull Iterable<? extends CommonSearchResultModel> searchResultList, @Nonnull AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableSet ids = ImmutableSet.copyOf((Iterable)Iterables.transform(searchResultList, (Function)this._getId));
        if (Iterables.isEmpty((Iterable)ids)) {
            return AdditionalSuggestData.AdditionalWorkstreamSuggestData.EMPTY;
        }
        ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> workstreamEntries = this._workstreamService.getWorkstreamEntries((Set<WorkstreamMessageId>)ids);
        if (workstreamEntries.isEmpty()) {
            return AdditionalSuggestData.AdditionalWorkstreamSuggestData.EMPTY;
        }
        ImmutableMap dbBeans = Maps.uniqueIndex((Iterable)workstreamEntries.values(), w -> CompoundId.of(w.getId()));
        ImmutableList<WorkstreamMessage> messages = this._workstreamService.getMessages(dbBeans.values(), (AuthorizationCheckContextWithLocale)authorizationContext);
        ImmutableMap messagesMap = Maps.uniqueIndex(messages, Identifiables.toId());
        return new AdditionalSuggestData.AdditionalWorkstreamSuggestData((Map<CompoundId, DBWorkstreamMessage>)dbBeans, (Map<WorkstreamMessageId, WorkstreamMessage>)messagesMap);
    }
}

