/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.criteria.Criterion;
import de.justsoftware.onx.searchnew.business.criteria.EqExpression;
import de.justsoftware.onx.searchnew.business.criteria.LocalParam;
import de.justsoftware.onx.searchnew.business.criteria.LocalParamCriterion;
import de.justsoftware.onx.searchnew.business.criteria.OrExpression;
import de.justsoftware.onx.searchnew.business.criteria.Restrictions;
import de.justsoftware.onx.searchnew.business.impl.FilterTagResolver;
import de.justsoftware.onx.searchnew.business.impl.SolrQueryBuilder;
import de.justsoftware.onx.searchnew.business.impl.SubFilterToSearchCriterionVisitor;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.searchnew.business.model.SubFilterSet;
import de.justsoftware.onx.searchnew.shared.model.DocumentFileTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DriveFileTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityDynamicAttributeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.EntityDynamicAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityStatusSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeVisitor;
import de.justsoftware.onx.searchnew.shared.model.PersonRoleSubFilter;
import de.justsoftware.onx.searchnew.shared.model.ProfileAttributeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.ProfileAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchContextFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchContextModel;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.TagSubFilter;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ToSolrFacetVisitor
implements SearchFacet.SearchFacetVisitor<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(ToSolrFacetVisitor.class);
    private static final int DEFAULT_FACET_LIMIT = 1000;
    private static final int DEFAULT_FACET_CONTAINS_LIMIT = 8;
    private final SolrQuery _query;
    private final SearchConfigurationProvider _searchConfigurationProvider;
    private final String _facetContains;
    private final SubFilterSet _subfilter;
    private final PersonId _currentUserId;
    private final SearchContextModel _searchContext;
    private final boolean _isNavigatorSearch;
    private final Set<? extends FilterType> _navigatorAllowedFilterTypes;
    private final ImmutableSetMultimap<EntityType, DynamicAttributeConfig> _entityDynamicAttributeConfigs;

    public ToSolrFacetVisitor(SolrQuery query, SearchConfigurationProvider searchConfigurationProvider, @Nullable String facetContains, Iterable<? extends SubFilter> subfilter, ImmutableSetMultimap<EntityType, DynamicAttributeConfig> entityDynamicAttributeConfigs, @Nullable PersonId currentUserId, @Nullable SearchContextModel searchContext, boolean isNavigatorSearch, @Nullable Set<? extends FilterType> navigatorAllowedFilterTypes) {
        this._query = query;
        this._searchConfigurationProvider = searchConfigurationProvider;
        this._facetContains = facetContains;
        this._entityDynamicAttributeConfigs = entityDynamicAttributeConfigs;
        this._subfilter = new SubFilterSet(subfilter);
        this._currentUserId = currentUserId;
        this._searchContext = searchContext;
        this._isNavigatorSearch = isNavigatorSearch;
        this._navigatorAllowedFilterTypes = navigatorAllowedFilterTypes;
    }

    @Override
    public Void visitDateAll(SearchFacet searchFacet) {
        return this.addAllFacetQuery(searchFacet);
    }

    @Override
    public Void visitDateFuture(SearchFacet searchFacet) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        this._query.addFacetQuery(SolrQueryBuilder.getFacetQueryWithExclusion(CommonSearchFields.END_DATE.getFieldName(), "[NOW/DAY TO *]", searchFacet.getFacetName(), filterExcludeName));
        return null;
    }

    @Override
    public Void visitDatePast(SearchFacet searchFacet) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        this._query.addFacetQuery(SolrQueryBuilder.getFacetQueryWithExclusion(CommonSearchFields.START_DATE.getFieldName(), "[* TO NOW/DAY-1MINUTE]", searchFacet.getFacetName(), filterExcludeName));
        return null;
    }

    @Override
    public Void visitDocumentFileType(SearchFacet searchFacet) {
        this.addRegularFacetFieldFor(searchFacet, "file_type_id", this._subfilter.getMultiSelectValuesAsStrings(DocumentFileTypeSubFilter.class, Functions.toStringFunction()));
        return null;
    }

    @Override
    public Void visitModifyDateAll(SearchFacet searchFacet) {
        return this.addAllFacetQuery(searchFacet);
    }

    @Override
    public Void visitModifyDateLastHour(SearchFacet searchFacet) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        this._query.addFacetQuery(SolrQueryBuilder.getFacetQueryWithExclusion("modify_date", "[NOW/HOUR-1HOUR TO *]", searchFacet.getFacetName(), filterExcludeName));
        return null;
    }

    @Override
    public Void visitModifyDateLast24Hours(SearchFacet searchFacet) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        this._query.addFacetQuery(SolrQueryBuilder.getFacetQueryWithExclusion("modify_date", "[NOW/HOUR-1DAY TO *]", searchFacet.getFacetName(), filterExcludeName));
        return null;
    }

    @Override
    public Void visitModifyDateLastWeek(SearchFacet searchFacet) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        this._query.addFacetQuery(SolrQueryBuilder.getFacetQueryWithExclusion("modify_date", "[NOW/DAY-7DAYS TO *]", searchFacet.getFacetName(), filterExcludeName));
        return null;
    }

    @Override
    public Void visitModifyDateLastMonth(SearchFacet searchFacet) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        this._query.addFacetQuery(SolrQueryBuilder.getFacetQueryWithExclusion("modify_date", "[NOW/DAY-1MONTH TO *]", searchFacet.getFacetName(), filterExcludeName));
        return null;
    }

    @Override
    public Void visitModifyDateLastYear(SearchFacet searchFacet) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        this._query.addFacetQuery(SolrQueryBuilder.getFacetQueryWithExclusion("modify_date", "[NOW/DAY-1YEAR TO *]", searchFacet.getFacetName(), filterExcludeName));
        return null;
    }

    @Override
    public Void visitDynamicEntityAttribute(EntityDynamicAttributeSearchFacet searchFacet) {
        ImmutableSet<String> selectedSubfilterValues = this._subfilter.getMultiSelectValuesAsStrings(EntityDynamicAttributeSubFilter.class, EntityDynamicAttributeSubFilter.attributeIdEqualsPredicate(searchFacet.getDynamicAttributeId()), String::toLowerCase);
        DynamicAttributeConfig attributeConfig = (DynamicAttributeConfig)Iterables.find((Iterable)this._entityDynamicAttributeConfigs.get((Object)searchFacet.getEntityType()), Identifiables.idEquals(searchFacet.getDynamicAttributeId()), null);
        if (attributeConfig == null) {
            LOG.error("Did not find entity dynamic attribute configuration for id " + searchFacet.getDynamicAttributeId() + ", skipping this facet.");
            return null;
        }
        this.addRegularFacetFieldFor(searchFacet, searchFacet.getFacetName(), selectedSubfilterValues);
        return null;
    }

    @Override
    public Void visitArchiveAll(SearchFacet searchFacet) {
        return this.addAllFacetQuery(searchFacet);
    }

    @Override
    public Void visitArchiveNonArchived(SearchFacet searchFacet) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        StringBuilder myFacetQuery = new StringBuilder("-");
        myFacetQuery.append("expiration_date");
        myFacetQuery.append(":[* TO NOW]");
        this._query.addFacetQuery(SolrQueryBuilder.getGenericFacetQueryWithExclusion(myFacetQuery.toString(), searchFacet.getFacetName(), filterExcludeName));
        return null;
    }

    @Override
    public Void visitArchiveArchived(SearchFacet searchFacet) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        this._query.addFacetQuery(SolrQueryBuilder.getFacetQueryWithExclusion("expiration_date", "[* TO NOW]", searchFacet.getFacetName(), filterExcludeName));
        return null;
    }

    @Override
    public Void visitBlockAll(SearchFacet searchFacet) {
        return this.addAllFacetQuery(searchFacet);
    }

    @Override
    public Void visitBlockNonBlocked(SearchFacet searchFacet) {
        this.addBlockFacet(searchFacet, false);
        return null;
    }

    @Override
    public Void visitBlockBlocked(SearchFacet searchFacet) {
        this.addBlockFacet(searchFacet, true);
        return null;
    }

    @Override
    public Void visitEntityStatus(EntityStatusSearchFacet searchFacet) {
        this.addRegularFacetFieldFor(searchFacet, "entity_facet_status", (ImmutableSet<String>)ImmutableSet.of());
        return null;
    }

    private void addBlockFacet(SearchFacet searchFacet, boolean blocked) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        this._query.addFacetQuery(SolrQueryBuilder.getFacetQueryWithExclusion("blocked", Boolean.toString(blocked), searchFacet.getFacetName(), filterExcludeName));
    }

    @CheckForNull
    private Void addAllFacetQuery(SearchFacet searchFacet) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        this._query.addFacetQuery(SolrQueryBuilder.getGenericFacetQueryWithExclusion("*:*", searchFacet.getFacetName(), filterExcludeName));
        return null;
    }

    @Override
    public Void visitAllContent(SearchContextFacet.AllContentSearchFacet searchFacet) {
        return this.addAllFacetQuery(searchFacet);
    }

    @Override
    public Void visitEntityContext(SearchContextFacet.EntityBasedSearchContextFacet searchFacet) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        this._query.addFacetQuery(SolrQueryBuilder.getFacetQueryWithExclusion(searchFacet.isIncludeSubentities() ? "parent_ids" : "direct_parent_ids", searchFacet.getEntityId().asString(), searchFacet.getFacetName(), filterExcludeName));
        return null;
    }

    @Override
    public Void visitMySubscriptions(SearchContextFacet.MySubscriptionsSearchFacet searchFacet) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        this._query.addFacetQuery(SolrQueryBuilder.getFacetQueryWithExclusion("subscriber_ids", CompoundId.of(searchFacet.getUserId()).toSearchString(), searchFacet.getFacetName(), filterExcludeName));
        return null;
    }

    @Override
    public Void visitMyContent(SearchContextFacet.MyContentSearchFacet searchFacet) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        String fieldName = searchFacet.getUserId().equals(this._currentUserId) ? "my_content_person_ids" : "user_content_person_ids";
        this._query.addFacetQuery(SolrQueryBuilder.getFacetQueryWithExclusion(fieldName, CompoundId.of(searchFacet.getUserId()).toSearchString(), searchFacet.getFacetName(), filterExcludeName));
        return null;
    }

    @Override
    public Void visitMemberRole(SearchContextFacet.MemberRoleSearchFacet searchFacet) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        this._query.addFacetQuery(SolrQueryBuilder.getFacetQueryWithExclusion("member_ids", CompoundId.of(searchFacet.getUserId()).toSearchString(), searchFacet.getFacetName(), filterExcludeName));
        return null;
    }

    @Override
    public Void visitAdminRole(SearchContextFacet.AdminRoleSearchFacet searchFacet) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        this._query.addFacetQuery(SolrQueryBuilder.getFacetQueryWithExclusion("admin_ids", CompoundId.of(searchFacet.getUserId()).toSearchString(), searchFacet.getFacetName(), filterExcludeName));
        return null;
    }

    @Override
    public Void visitPersonRole(SearchFacet searchFacet) {
        this.addRegularFacetFieldFor(searchFacet, "roles_not_hidden", this._subfilter.getMultiSelectValues(PersonRoleSubFilter.class));
        return null;
    }

    private void addRegularFacetFieldFor(SearchFacet searchFacet, String field, ImmutableSet<String> subfilterValues) {
        ImmutableList<String> filterExcludeName = FilterTagResolver.INSTANCE.getFacetQueryExclusionTags(searchFacet);
        this._query.addFacetField(new String[]{SolrQueryBuilder.getFacetFieldWithExclusion(field, searchFacet.getFacetName(), filterExcludeName)});
        SolrQueryBuilder.setFacetFieldSortByCount(this._query, field);
        if (Strings.isNullOrEmpty((String)this._facetContains)) {
            SolrQueryBuilder.setFacetFieldLimit(this._query, field, 1000);
        } else {
            SolrQueryBuilder.setFacetFieldContains(this._query, field, this._facetContains);
            SolrQueryBuilder.setFacetFieldLimit(this._query, field, 8);
        }
        if (!subfilterValues.isEmpty()) {
            for (String filterValue : subfilterValues) {
                this._query.addFacetQuery(SolrQueryBuilder.getFacetQueryWithExclusion(field, ClientUtils.escapeQueryChars((String)filterValue), "\"" + searchFacet.getFacetName() + ":" + ClientUtils.escapeQueryChars((String)filterValue) + "\"", filterExcludeName));
            }
        }
    }

    @Override
    public Void visitTag(StaticSearchFacet staticSearchFacet) {
        this.addRegularFacetFieldFor(StaticSearchFacet.TAG, "tags_for_facet_search", this._subfilter.getMultiSelectValuesAsStrings(TagSubFilter.class, String::toLowerCase));
        return null;
    }

    @Override
    public Void visitDriveFileType(StaticSearchFacet staticSearchFacet) {
        this.addRegularFacetFieldFor(StaticSearchFacet.DRIVE_FILE_TYPE, "drive_file_type", this._subfilter.getMultiSelectValuesAsStrings(DriveFileTypeSubFilter.class, String::toLowerCase));
        return null;
    }

    @Override
    public Void visitFilterTypeSearchFacet(FilterTypeSearchFacet searchFacet) {
        Criterion typeQuery = searchFacet.getFilterType().accept(new FilterTypeToSolrCriterionVisitor(this._searchContext, searchFacet, this._isNavigatorSearch, this._navigatorAllowedFilterTypes));
        FluentIterable facetFilterCriteria = this.getDefaultFilter(searchFacet).append((Object[])new Criterion[]{typeQuery}).filter(Predicates.notNull());
        Criterion facetCriterion = Restrictions.and((Iterable<Criterion>)facetFilterCriteria);
        LocalParamCriterion facetQuery = Restrictions.localParams(new LocalParam("ex", "subfilter", "type", "context"), facetCriterion, false);
        facetQuery.addLocalParam(new LocalParam("key", searchFacet.getFacetName()));
        this._query.addFacetQuery(facetQuery.toSolrQuery());
        return null;
    }

    @Nonnull
    private FluentIterable<Criterion> getDefaultFilter(FilterTypeSearchFacet searchFacet) {
        SortType defaultSortType = SearchParameters.createDefaultSortType(this._searchConfigurationProvider, this._query.getQuery(), searchFacet, null);
        ImmutableSet<SubFilter> defaultSubfilterForType = SearchParameters.createDefaultSubFilter(this._searchConfigurationProvider, defaultSortType, searchFacet.getFilterType());
        PersonId restrictedMyContextUser = searchFacet.getRestrictedMyContextUser();
        String fieldName = restrictedMyContextUser == null || restrictedMyContextUser.equals(this._currentUserId) ? "my_content_person_ids" : "user_content_person_ids";
        EqExpression<String> contextFilter = restrictedMyContextUser != null ? Restrictions.eq(fieldName, CompoundId.of(restrictedMyContextUser).toSearchString()) : null;
        SubFilterToSearchCriterionVisitor subfilterToSearchCriterionVisitor = new SubFilterToSearchCriterionVisitor((ImmutableSetMultimap<EntityType, DynamicAttributeConfig>)ImmutableSetMultimap.of());
        return FluentIterable.from(defaultSubfilterForType).transform((Function)subfilterToSearchCriterionVisitor).append((Object[])new Criterion[]{contextFilter}).filter(Predicates.notNull());
    }

    @Override
    public Void visitProfileAttribute(final ProfileAttributeSearchFacet searchFacet) {
        this.addRegularFacetFieldFor(searchFacet, searchFacet.getFacetName(), this._subfilter.getMultiSelectValues(ProfileAttributeSubFilter.class, new NullIsFalsePredicate<ProfileAttributeSubFilter>(){

            @Override
            protected boolean applySafe(ProfileAttributeSubFilter input) {
                return input.getName().equals(searchFacet.getName());
            }
        }));
        return null;
    }

    @Override
    public Void visitDriveDocumentType(SearchFacet searchFacet) {
        this.addRegularFacetFieldFor(searchFacet, "drive_document_type", this._subfilter.getMultiSelectValuesAsStrings(DriveDocumentTypeSubFilter.class, Functions.toStringFunction()));
        return null;
    }

    @ParametersAreNonnullByDefault
    private static final class FilterTypeToSolrCriterionVisitor
    implements FilterTypeVisitor<Criterion> {
        private final SearchContextModel _searchContext;
        private final FilterTypeSearchFacet _searchFacet;
        private final boolean _isNavigatorSearch;
        private final Set<? extends FilterType> _navigatorAllowedFilterTypes;

        public FilterTypeToSolrCriterionVisitor(@Nullable SearchContextModel searchContext, FilterTypeSearchFacet searchFacet, boolean isNavigatorSearch, @Nullable Set<? extends FilterType> navigatorAllowedFilterTypes) {
            this._searchContext = searchContext;
            this._searchFacet = searchFacet;
            this._isNavigatorSearch = isNavigatorSearch;
            this._navigatorAllowedFilterTypes = navigatorAllowedFilterTypes;
        }

        @Override
        @Nonnull
        public Criterion visitDefault() {
            return this.createEqTypeAndContextCriterion();
        }

        @Nonnull
        private Criterion createEqTypeAndContextCriterion() {
            Criterion typeFilterCriterion = this.createEqTypeCriterion(this._searchFacet.getFilterType().getType().name());
            Criterion navigatorEntityContextFilterCriterion = this.getNavigatorEntityContextFilterCriterion();
            if (navigatorEntityContextFilterCriterion != null) {
                return Restrictions.and(typeFilterCriterion, navigatorEntityContextFilterCriterion);
            }
            return typeFilterCriterion;
        }

        @CheckForNull
        private Criterion getNavigatorEntityContextFilterCriterion() {
            if (!this._isNavigatorSearch || this._searchContext == null) {
                return null;
            }
            EntityId contextId = this._searchContext.getContextEntityId();
            if (contextId == null) {
                return null;
            }
            if (SearchContext.ENTITY.equals((Object)this._searchContext.getSelectedContext())) {
                return Restrictions.eq("direct_parent_ids", contextId.asString());
            }
            if (SearchContext.ENTITY_AND_SUBENTITIES.equals((Object)this._searchContext.getSelectedContext())) {
                return Restrictions.eq("parent_ids", contextId.asString());
            }
            return null;
        }

        @Nonnull
        private Criterion createEqTypeCriterion(String type) {
            return Restrictions.eq("type", type);
        }

        @Override
        public Criterion visitAll() {
            Criterion filterTypesCriterion;
            if (!this._isNavigatorSearch) {
                return this.createEqTypeCriterion("*");
            }
            if (this._navigatorAllowedFilterTypes == null || this._navigatorAllowedFilterTypes.isEmpty()) {
                filterTypesCriterion = this.createEqTypeCriterion("*");
            } else {
                OrExpression criterion = Restrictions.or(new Criterion[0]);
                for (FilterType filterType : this._navigatorAllowedFilterTypes) {
                    criterion.add(this.createEqTypeCriterion(filterType.getType().name()));
                }
                filterTypesCriterion = criterion;
            }
            Criterion navigatorEntityContextFilterCriterion = this.getNavigatorEntityContextFilterCriterion();
            if (navigatorEntityContextFilterCriterion != null) {
                return Restrictions.and(filterTypesCriterion, navigatorEntityContextFilterCriterion);
            }
            return filterTypesCriterion;
        }
    }
}

