/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.shared.model.LongId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.attributes.ArithmeticOperationInput;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.EntityDynamicAttributesUtil;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import de.justsoftware.onx.common.shared.model.attributes.NumberInput;
import de.justsoftware.onx.common.shared.model.attributes.PersonSuggestInput;
import de.justsoftware.onx.common.shared.model.attributes.SelectionInput;
import de.justsoftware.onx.common.shared.model.attributes.TextAreaInput;
import de.justsoftware.onx.common.shared.model.attributes.TextInput;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.searchnew.business.criteria.Criterion;
import de.justsoftware.onx.searchnew.business.criteria.JoinExpression;
import de.justsoftware.onx.searchnew.business.criteria.Restrictions;
import de.justsoftware.onx.searchnew.business.impl.SolrQueryBuilder;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.searchnew.shared.model.ArchiveSubFilter;
import de.justsoftware.onx.searchnew.shared.model.BlockSubFilter;
import de.justsoftware.onx.searchnew.shared.model.CoadminSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DocumentFileTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DriveFileTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityDynamicAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityMemberSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityStatusSubFilter;
import de.justsoftware.onx.searchnew.shared.model.InheritAdminSubFilter;
import de.justsoftware.onx.searchnew.shared.model.InheritMemberSubFilter;
import de.justsoftware.onx.searchnew.shared.model.ModificationDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.OrSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PersonIdSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PersonRoleSubFilter;
import de.justsoftware.onx.searchnew.shared.model.ProfileAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PublicationDateFilter;
import de.justsoftware.onx.searchnew.shared.model.StartAndEndDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.StartDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.SubFilterVisitor;
import de.justsoftware.onx.searchnew.shared.model.TagSubFilter;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubFilterToSearchCriterionVisitor
extends NullPermeableFunction<SubFilter, Criterion>
implements SubFilterVisitor<Criterion> {
    private static final Logger LOG = LoggerFactory.getLogger(SubFilterToSearchCriterionVisitor.class);
    private static final DateTimeFormatter ISO6801_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final ImmutableSetMultimap<EntityType, DynamicAttributeConfig> _entityDynamicAttributeConfigs;

    public SubFilterToSearchCriterionVisitor(@Nonnull ImmutableSetMultimap<EntityType, DynamicAttributeConfig> entityDynamicAttributeConfigs) {
        this._entityDynamicAttributeConfigs = entityDynamicAttributeConfigs;
    }

    @Override
    protected Criterion applySafe(SubFilter input) {
        return input.accept(this);
    }

    @Override
    public Criterion visitDateSubFilter(DateSubFilter filter) {
        if (filter.isDisplayFutureEvents()) {
            return Restrictions.range("end_date", "NOW/DAY", "*");
        }
        return Restrictions.range("start_date", "*", "NOW/DAY-1MINUTE");
    }

    @Override
    public Criterion visitPersonRoleSubFilter(PersonRoleSubFilter filter) {
        return Restrictions.eq("roles", filter.getFilterValues(), Functions.identity());
    }

    @Override
    public Criterion visitStartDateSubFilter(StartDateSubFilter filter) {
        String startTime = ISO6801_FORMAT.print(filter.getStartDate().getTime()) + "/DAY";
        return Restrictions.range("end_date", startTime, "*");
    }

    @Override
    public Criterion visitStartAndEndDateSubFilter(StartAndEndDateSubFilter filter) {
        String startTime = ISO6801_FORMAT.print(filter.getStart().getTime()) + "/DAY";
        String endTime = ISO6801_FORMAT.print(filter.getEnd().getTime()) + "/DAY";
        return Restrictions.and(Restrictions.range("start_date", "*", endTime), Restrictions.range("end_date", startTime, "*"));
    }

    @Override
    public Criterion visitPersonIdSubFilter(PersonIdSubFilter personIdSubFilter) {
        Set<PersonId> personIds = personIdSubFilter.getPersonIds();
        ImmutableList.Builder criterionBuilder = ImmutableList.builder();
        for (PersonId pId : personIds) {
            criterionBuilder.add(Restrictions.eq("id", CompoundId.of(pId).toSearchString()));
        }
        return Restrictions.or((Iterable<Criterion>)criterionBuilder.build());
    }

    @Override
    public Criterion visitOrSubFilter(OrSubFilter orSubFilter) {
        ImmutableList.Builder criterionBuilder = ImmutableList.builder();
        for (SubFilter childFilter : orSubFilter.getChildFilter()) {
            Criterion childCriterion = childFilter.accept(this);
            if (childCriterion == null) continue;
            criterionBuilder.add((Object)childCriterion);
        }
        return Restrictions.or((Iterable<Criterion>)criterionBuilder.build());
    }

    @Override
    public Criterion visitEntityMemberSubFilter(EntityMemberSubFilter entityMemberSubFilter) {
        Set<EntityId> entityIds = entityMemberSubFilter.getEntityIds();
        ImmutableList.Builder criterionBuilder = ImmutableList.builder();
        for (EntityId entityId : entityIds) {
            criterionBuilder.add(Restrictions.eq("direct_parent_ids", entityId.asString()));
        }
        return Restrictions.or((Iterable<Criterion>)criterionBuilder.build());
    }

    @Override
    public Criterion visitPublicationDate(PublicationDateFilter publicationDateFilter) {
        Date from = publicationDateFilter.from();
        Date until = publicationDateFilter.until();
        return Restrictions.range("publication_date", from == null ? "*" : ISO6801_FORMAT.print(from.getTime()), until == null ? "*" : ISO6801_FORMAT.print(until.getTime()));
    }

    @Override
    public Criterion visitDocumentFileType(DocumentFileTypeSubFilter subfilter) {
        ImmutableList.Builder criterionBuilder = ImmutableList.builder();
        for (Long fileTypeId : subfilter.getFilterValues()) {
            criterionBuilder.add(Restrictions.eq("file_type_id", fileTypeId));
        }
        return Restrictions.or((Iterable<Criterion>)criterionBuilder.build());
    }

    @Override
    public Criterion visitModificationDate(ModificationDateSubFilter subfilter) {
        switch (subfilter) {
            case LAST_HOUR: {
                return Restrictions.range("modify_date", "NOW/HOUR-1HOUR", "*");
            }
            case LAST_24HOURS: {
                return Restrictions.range("modify_date", "NOW/HOUR-1DAY", "*");
            }
            case LAST_WEEK: {
                return Restrictions.range("modify_date", "NOW/DAY-7DAYS", "*");
            }
            case LAST_MONTH: {
                return Restrictions.range("modify_date", "NOW/DAY-1MONTH", "*");
            }
            case LAST_YEAR: {
                return Restrictions.range("modify_date", "NOW/DAY-1YEAR", "*");
            }
        }
        return null;
    }

    @Override
    public Criterion visitEntityDynamicAttributeSubFilter(final EntityDynamicAttributeSubFilter subFilter) {
        DynamicAttributeConfig attributeConfig = (DynamicAttributeConfig)Iterables.find((Iterable)this._entityDynamicAttributeConfigs.get((Object)subFilter.getEntityType()), Identifiables.idEquals(subFilter.getAttributeId()), null);
        if (attributeConfig == null) {
            LOG.error("Did not find entity dynamic attribute configuration for id " + subFilter.getAttributeId() + ", skipping this subfilter.");
            return null;
        }
        String searchField = attributeConfig.getInput().accept(new Input.InputVisitor<String>(){

            @Nonnull
            private String getFacetField() {
                return EntityDynamicAttributesUtil.toFacetFieldName(subFilter.getAttributeId(), subFilter.getEntityType());
            }

            @Nonnull
            private String getSearchField() {
                return EntityDynamicAttributesUtil.toSearchFieldName(subFilter.getAttributeId(), subFilter.getEntityType());
            }

            @Override
            public String visit(SelectionInput input) {
                return this.getFacetField();
            }

            @Override
            public String visit(TextInput input) {
                return this.getSearchField();
            }

            @Override
            public String visit(TextAreaInput input) {
                return this.getSearchField();
            }

            @Override
            public String visit(NumberInput numberInput) {
                return this.getSearchField();
            }

            @Override
            public String visit(ArithmeticOperationInput arithmeticOperationInput) {
                return this.getSearchField();
            }

            @Override
            public String visit(PersonSuggestInput suggestInput) {
                return this.getFacetField();
            }
        });
        return Restrictions.eq(searchField, subFilter.getFilterValues(), SolrQueryBuilder.ESCAPE_QUERY_CHARS);
    }

    @Override
    public Criterion visitInheritMemberSubFilter(InheritMemberSubFilter inheritMemberSubFilter) {
        return new JoinExpression("inherit_member_ids", "id", Restrictions.eq("id", CompoundId.of(inheritMemberSubFilter.getEntityId()).toSearchString()));
    }

    @Override
    public Criterion visitInheritAdminSubFilter(InheritAdminSubFilter inheritAdminSubFilter) {
        return new JoinExpression("inherit_admin_ids", "id", Restrictions.eq("id", CompoundId.of(inheritAdminSubFilter.getEntityId()).toSearchString()));
    }

    @Override
    public Criterion visitCoadminSubFilter(CoadminSubFilter coadminSubFilter) {
        return new JoinExpression("direct_admin_ids", "id", Restrictions.eq("id", CompoundId.of(coadminSubFilter.getEntityId()).toSearchString()));
    }

    @Override
    public Criterion visitArchiveSubFilter(ArchiveSubFilter archiveSubFilter) {
        switch (archiveSubFilter) {
            case ARCHIVED: {
                return Restrictions.range("expiration_date", "*", "NOW");
            }
            case NON_ARCHIVED: {
                return Restrictions.not(Restrictions.range("expiration_date", "*", "NOW"));
            }
        }
        return null;
    }

    @Override
    public Criterion visitBlockedSubFilter(BlockSubFilter blockedSubFilter) {
        return Restrictions.eq("blocked", blockedSubFilter == BlockSubFilter.BLOCKED ? "true" : "false");
    }

    @Override
    public Criterion visitEntityStatusSubFilter(EntityStatusSubFilter entityStatusSubFilter) {
        return Restrictions.eq("entity_facet_status", entityStatusSubFilter.getStatusIds(), LongId.TO_LONG);
    }

    @Override
    public Criterion visitTagSubFilter(TagSubFilter tagSubFilter) {
        return Restrictions.eq("tags_for_facet_search", tagSubFilter.getFilterValues(), SolrQueryBuilder.ESCAPE_QUERY_CHARS);
    }

    @Override
    public Criterion visitDriveFileTypeSubFilter(DriveFileTypeSubFilter driveFileTypeSubFilter) {
        return Restrictions.eq("drive_file_type", driveFileTypeSubFilter.getFilterValues(), SolrQueryBuilder.ESCAPE_QUERY_CHARS);
    }

    @Override
    public Criterion visitProfileAttributeSubFilter(ProfileAttributeSubFilter subfilter) {
        return Restrictions.eq("profile_facet_dynamic_" + subfilter.getName(), subfilter.getFilterValues(), SolrQueryBuilder.ESCAPE_QUERY_CHARS);
    }

    @Override
    public Criterion visitDriveDocumentTypeSubFilter(DriveDocumentTypeSubFilter driveDocumentTypeSubfilter) {
        ImmutableList.Builder criterionBuilder = ImmutableList.builder();
        for (DriveDocumentSearchResultBadgeModel.DocumentType documentType : driveDocumentTypeSubfilter.getFilterValues()) {
            criterionBuilder.add(Restrictions.eq("drive_document_type", documentType));
        }
        return Restrictions.or((Iterable<Criterion>)criterionBuilder.build());
    }
}

