/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.container.shared.model.SearchableId;
import java.util.Map;
import javax.annotation.Nonnull;

public class SolrRequestException
extends Exception {
    private static final long serialVersionUID = 7182961516121291009L;
    private final ImmutableSetMultimap<SearchableId, Exception> _errors;

    public SolrRequestException(@Nonnull Throwable cause) {
        super(cause);
        this._errors = ImmutableSetMultimap.of();
    }

    public SolrRequestException(@Nonnull ImmutableSetMultimap<SearchableId, Exception> errors) {
        super(SolrRequestException.message(errors), (Throwable)Iterables.getFirst((Iterable)errors.values(), null));
        this._errors = errors;
    }

    @Nonnull
    private static String message(@Nonnull ImmutableSetMultimap<SearchableId, Exception> errors) {
        String linebreak = "";
        StringBuilder sb = new StringBuilder();
        for (Map.Entry errorEntry : errors.entries()) {
            sb.append(linebreak).append("Error for ").append(errorEntry.getKey()).append(": ").append(((Exception)errorEntry.getValue()).getMessage());
            linebreak = "\n";
        }
        return sb.toString();
    }

    @Nonnull
    public ImmutableSetMultimap<SearchableId, Exception> getErrors() {
        return this._errors;
    }
}

