/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import de.justsoftware.onx.searchnew.business.SolrAdminService;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ContentStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="solrAdminService")
public class SolrAdminServiceImpl
implements SolrAdminService {
    private final SolrClient _writeSolrServer;

    @Autowired
    public SolrAdminServiceImpl(@Nonnull @Qualifier(value="writeSolrServer") SolrClient writeSolrServer) {
        this._writeSolrServer = writeSolrServer;
    }

    @Override
    public void saveConfigFileToSolr(String solrConfigFilename, ContentStream contentStream) throws ServiceException {
        ContentStreamUpdateRequest request = new ContentStreamUpdateRequest("/admin/fileupload");
        request.setParam("file", solrConfigFilename);
        request.addContentStream(contentStream);
        try {
            UpdateResponse response = (UpdateResponse)request.process(this._writeSolrServer);
            if (!"success".equals(response.getResponse().get("status"))) {
                throw new ServiceException("Saving config file to solr failed!");
            }
        }
        catch (SolrServerException e) {
            throw new ServiceException(e);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        catch (SolrException e) {
            throw new ServiceException(e);
        }
    }
}

