/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sun.syndication.feed.synd.SyndEntry;
import de.justsoftware.onx.searchnew.business.impl.OpenSearchSearchService;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class SharePointSearchService
extends OpenSearchSearchService {
    private Map<String, String> _replacements = Maps.newHashMap();
    private final Function<SyndEntry, FederatedSearchResultEntry> _sharepointToResultEntryFunction = new Function<SyndEntry, FederatedSearchResultEntry>(){

        public FederatedSearchResultEntry apply(SyndEntry input) {
            if (input == null) {
                return null;
            }
            String title = input.getTitle();
            String link = input.getLink();
            if (title == null || link == null) {
                return null;
            }
            link = this.applyReplacements(link);
            String description = "";
            if (input.getDescription() != null) {
                description = this.applyReplacements(input.getDescription().getValue());
            }
            return SharePointSearchService.this.createResult(title, link, description);
        }

        @Nonnull
        private final String applyReplacements(@Nonnull String original) {
            String toReplace = original;
            for (Map.Entry<String, String> entry : SharePointSearchService.this._replacements.entrySet()) {
                toReplace = toReplace.replaceAll(entry.getKey(), entry.getValue());
            }
            return toReplace;
        }
    };

    @Override
    protected ImmutableList<FederatedSearchResultEntry> transformResults(int offset, List<SyndEntry> entries) {
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Lists.transform(entries, this._sharepointToResultEntryFunction), (Predicate)Predicates.notNull()));
    }

    public void setReplacements(@Nonnull Map<String, String> replacements) {
        this._replacements = replacements;
    }
}

