/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import de.justsoftware.onx.searchnew.business.SearchLtrTrackingPublisher;
import de.justsoftware.onx.searchnew.business.model.SearchLtrFeedbackTrackingInfo;
import de.justsoftware.onx.searchnew.business.model.SearchLtrSearchTrackingInfo;
import de.justsoftware.onx.searchnew.shared.model.LearnToRankToggleValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class SearchLtrTrackingPublisherImpl
implements SearchLtrTrackingPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(SearchLtrTrackingPublisherImpl.class);
    private final Producer<String, String> _producer;
    private final Settings _settings;
    private final ObjectMapper _mapper = new ObjectMapper();

    @Autowired
    public SearchLtrTrackingPublisherImpl(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") Producer<String, String> producer, Settings settings) {
        this._producer = producer;
        this._settings = settings;
        this._mapper.registerModule((Module)new JodaModule());
    }

    @Override
    public void trackSearch(SearchLtrSearchTrackingInfo trackingInfo) {
        if (this._settings.getLearnToRankEnabled() == LearnToRankToggleValue.DISABLED) {
            return;
        }
        try {
            this.publish(trackingInfo.getSearchTrackingId(), this._mapper.writeValueAsString((Object)trackingInfo));
        }
        catch (JsonProcessingException e) {
            LOG.error("Error serializing search tracking info to JSON", (Throwable)e);
        }
    }

    @Override
    public void trackFeedback(SearchLtrFeedbackTrackingInfo trackingInfo) {
        if (this._settings.getLearnToRankEnabled() == LearnToRankToggleValue.DISABLED) {
            return;
        }
        try {
            this.publish(trackingInfo.getSearchTrackingId(), this._mapper.writeValueAsString((Object)trackingInfo));
        }
        catch (JsonProcessingException e) {
            LOG.error("Error serializing feedback tracking info to JSON", (Throwable)e);
        }
    }

    private void publish(String trackingId, String json) {
        if (this._producer == null) {
            return;
        }
        this._producer.send(new ProducerRecord("just.search.ltr.tracking", (Object)trackingId, (Object)json));
    }
}

