/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityChildrenService;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.events.business.UpdateEventProcessor;
import de.justsoftware.onx.events.shared.server.model.UpdateEventType;
import de.justsoftware.onx.searchnew.business.SearchIndexService;
import de.justsoftware.onx.searchnew.business.impl.UpdateEventTypeToDBSearchIndexQueueEntriesVisitor;
import de.justsoftware.onx.searchnew.shared.server.model.DBSearchIndexQueueEntry;
import de.justsoftware.onx.workstream.business.WorkstreamService;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="searchIndexUpdateEventProcessor")
public class SearchIndexUpdateEventProcessor
implements UpdateEventProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SearchIndexUpdateEventProcessor.class);
    @Autowired
    private EntityChildrenService _entityChildrenService;
    @Autowired
    private WorkstreamService _workstreamService;
    @Autowired
    private SearchIndexService _searchIndexService;
    @Autowired
    private Settings _settings;

    @Override
    public void processEventsOfType(UpdateEventType eventType, Set<ItemId> itemIds) {
        LOG.info("Processing events...");
        UpdateEventTypeToDBSearchIndexQueueEntriesVisitor visitor = new UpdateEventTypeToDBSearchIndexQueueEntriesVisitor(itemIds, this._entityChildrenService, this._workstreamService, this._settings);
        Set<DBSearchIndexQueueEntry> indexingItems = eventType.accept(visitor);
        if (!CollectionUtil.isEmpty(indexingItems)) {
            this._searchIndexService.queueItemsForIndex(indexingItems);
        }
        LOG.info("Processing events done!");
    }
}

