/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.monitoring.business.QueueStatisticsService;
import de.justsoftware.onx.monitoring.business.model.QueueName;
import de.justsoftware.onx.searchnew.business.CommonSearchService;
import de.justsoftware.onx.searchnew.business.SearchIndexService;
import de.justsoftware.onx.searchnew.business.data.SearchIndexTypesToDeleteVisitor;
import de.justsoftware.onx.searchnew.business.impl.SolrRequestException;
import de.justsoftware.onx.searchnew.business.model.SearchIndexType;
import de.justsoftware.onx.searchnew.integration.persistence.SearchIndexQueueDAO;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeVisitor;
import de.justsoftware.onx.searchnew.shared.server.model.DBSearchIndexQueueEntry;
import de.justsoftware.onx.searchnew.shared.server.model.SearchIndexQueueEntryId;
import de.justsoftware.permission.client.rest.PermissionRequestFailedExeception;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="searchIndexService")
public class SearchIndexServiceImpl
implements SearchIndexService {
    private static final Logger LOG = LoggerFactory.getLogger(SearchIndexServiceImpl.class);
    private static final long MAX_WAIT_ON_ERROR_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private static final long WAIT_ON_ERROR_MILLIS_STEP = TimeUnit.SECONDS.toMillis(1L);
    @Autowired
    private SearchIndexQueueDAO _indexQueueDAO;
    @Autowired
    private CommonSearchService _searchService;
    @Autowired
    private Settings _settings;
    @Autowired
    private QueueStatisticsService _queueStatisticsService;
    @Autowired
    private Clock _clock;

    @Override
    public void queueItemsForIndex(Set<DBSearchIndexQueueEntry> items) {
        this._indexQueueDAO.create(items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void updateSearchIndex() {
        List<DBSearchIndexQueueEntry> entries;
        int processErrorCount = 0;
        do {
            ImmutableSet distinctEntries;
            DateTime timeAfterLoadingBatch;
            boolean skipEntryDeletion;
            long startBatch;
            block17: {
                startBatch = this._clock.nowMillis();
                skipEntryDeletion = false;
                entries = this._indexQueueDAO.getEntries(this._settings.getSearchIndexFetchSize(), this._clock.now().minusMinutes(this._settings.getSearchIndexQueueMaxminutesInProcess()));
                timeAfterLoadingBatch = this._clock.now();
                if (entries.isEmpty()) continue;
                this.reportStatistics(entries);
                distinctEntries = ImmutableSet.copyOf(entries);
                LOG.info("Fetched {} entries ({} distinct) to index (took {} ms).", new Object[]{entries.size(), distinctEntries.size(), this._clock.now().getMillis() - startBatch});
                this.indexQueueEntries((ImmutableSet<DBSearchIndexQueueEntry>)distinctEntries);
                processErrorCount = 0;
                if (!skipEntryDeletion) break block17;
                this._indexQueueDAO.removeInProgressFlag((ImmutableSet<SearchIndexQueueEntryId>)FluentIterable.from(entries).transform(Identifiables.toId()).toSet());
                try {
                    Thread.sleep(SearchIndexServiceImpl.sleepTime(++processErrorCount));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            long deleteStart = this._clock.nowMillis();
            int deleted = this._indexQueueDAO.delete((Set<SearchIndexQueueEntryId>)FluentIterable.from(entries).transform(Identifiables.toId()).toSet());
            int deletedDuplicated = this.deleteDuplicates((Set<DBSearchIndexQueueEntry>)distinctEntries, timeAfterLoadingBatch);
            LOG.info("The processing of {} queue entries took {} ms ({} processed entries deleted, {} duplicated entries deleted, deleting entries tooks {} ms).", new Object[]{entries.size(), this._clock.nowMillis() - startBatch, deleted, deletedDuplicated, this._clock.nowMillis() - deleteStart});
            continue;
            catch (PermissionRequestFailedExeception e) {
                block18: {
                    LOG.warn("Failed to index items from the search index queue, permission service request fail. Index entries will be kept and indexed again.", (Throwable)e);
                    skipEntryDeletion = true;
                    if (!skipEntryDeletion) break block18;
                    this._indexQueueDAO.removeInProgressFlag((ImmutableSet<SearchIndexQueueEntryId>)FluentIterable.from(entries).transform(Identifiables.toId()).toSet());
                    try {
                        Thread.sleep(SearchIndexServiceImpl.sleepTime(++processErrorCount));
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                deleteStart = this._clock.nowMillis();
                deleted = this._indexQueueDAO.delete((Set<SearchIndexQueueEntryId>)FluentIterable.from(entries).transform(Identifiables.toId()).toSet());
                deletedDuplicated = this.deleteDuplicates((Set<DBSearchIndexQueueEntry>)distinctEntries, timeAfterLoadingBatch);
                LOG.info("The processing of {} queue entries took {} ms ({} processed entries deleted, {} duplicated entries deleted, deleting entries tooks {} ms).", new Object[]{entries.size(), this._clock.nowMillis() - startBatch, deleted, deletedDuplicated, this._clock.nowMillis() - deleteStart});
                continue;
            }
            catch (SolrRequestException | RuntimeException e2) {
                block19: {
                    LOG.error("Failed to index the fetched items from the search index queue! Index of these items will be skipped!", (Throwable)e2);
                    if (!skipEntryDeletion) break block19;
                    this._indexQueueDAO.removeInProgressFlag((ImmutableSet<SearchIndexQueueEntryId>)FluentIterable.from(entries).transform(Identifiables.toId()).toSet());
                    {
                        catch (Throwable throwable) {
                            if (skipEntryDeletion) {
                                this._indexQueueDAO.removeInProgressFlag((ImmutableSet<SearchIndexQueueEntryId>)FluentIterable.from(entries).transform(Identifiables.toId()).toSet());
                                try {
                                    Thread.sleep(SearchIndexServiceImpl.sleepTime(++processErrorCount));
                                }
                                catch (InterruptedException e3) {
                                    Thread.currentThread().interrupt();
                                }
                            } else {
                                long deleteStart2 = this._clock.nowMillis();
                                int deleted2 = this._indexQueueDAO.delete((Set<SearchIndexQueueEntryId>)FluentIterable.from(entries).transform(Identifiables.toId()).toSet());
                                int deletedDuplicated2 = this.deleteDuplicates((Set<DBSearchIndexQueueEntry>)distinctEntries, timeAfterLoadingBatch);
                                LOG.info("The processing of {} queue entries took {} ms ({} processed entries deleted, {} duplicated entries deleted, deleting entries tooks {} ms).", new Object[]{entries.size(), this._clock.nowMillis() - startBatch, deleted2, deletedDuplicated2, this._clock.nowMillis() - deleteStart2});
                            }
                            throw throwable;
                        }
                    }
                    try {
                        Thread.sleep(SearchIndexServiceImpl.sleepTime(++processErrorCount));
                    }
                    catch (InterruptedException e4) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                deleteStart = this._clock.nowMillis();
                deleted = this._indexQueueDAO.delete((Set<SearchIndexQueueEntryId>)FluentIterable.from(entries).transform(Identifiables.toId()).toSet());
                deletedDuplicated = this.deleteDuplicates((Set<DBSearchIndexQueueEntry>)distinctEntries, timeAfterLoadingBatch);
                LOG.info("The processing of {} queue entries took {} ms ({} processed entries deleted, {} duplicated entries deleted, deleting entries tooks {} ms).", new Object[]{entries.size(), this._clock.nowMillis() - startBatch, deleted, deletedDuplicated, this._clock.nowMillis() - deleteStart});
            }
        } while (entries.size() > 0);
    }

    private static long sleepTime(int errorCount) {
        long current = WAIT_ON_ERROR_MILLIS_STEP;
        for (int i = 1; i < errorCount; ++i) {
            if ((current += current) <= MAX_WAIT_ON_ERROR_MILLIS) continue;
            return MAX_WAIT_ON_ERROR_MILLIS;
        }
        return current;
    }

    @Override
    public int deleteDuplicates(Set<DBSearchIndexQueueEntry> distinctEntries, DateTime timeAfterLoadingBatch) {
        ImmutableSetMultimap current = (ImmutableSetMultimap)distinctEntries.stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(DBSearchIndexQueueEntry::getIndexType, DBSearchIndexQueueEntry::getItemId));
        ImmutableSet allEntries = current.get((Object)SearchIndexType.ALL);
        boolean deletedAllSeperately = allEntries.size() >= 5;
        ImmutableSetMultimap.Builder toDelete = ImmutableSetMultimap.builder();
        for (Map.Entry entry : current.asMap().entrySet()) {
            SearchIndexType indexType = (SearchIndexType)((Object)entry.getKey());
            if (deletedAllSeperately && indexType == SearchIndexType.ALL) continue;
            Iterable ids = deletedAllSeperately ? FluentIterable.from((Iterable)((Iterable)entry.getValue())).filter(Predicates.not((Predicate)Predicates.in((Collection)allEntries))) : (Iterable)entry.getValue();
            for (SearchIndexType type : SearchIndexTypesToDeleteVisitor.getTypesToDelete(indexType)) {
                toDelete.putAll((Object)type, ids);
            }
        }
        int deletedEntriesCount = 0;
        if (deletedAllSeperately) {
            deletedEntriesCount += this._indexQueueDAO.deleteEntriesOlderThan((Set<? extends ItemId>)allEntries, timeAfterLoadingBatch);
        }
        return deletedEntriesCount += this._indexQueueDAO.deleteEntriesOlderThan((SetMultimap<SearchIndexType, ? extends ItemId>)toDelete.build(), timeAfterLoadingBatch);
    }

    private void reportStatistics(@Nonnull List<DBSearchIndexQueueEntry> entries) {
        ImmutableList timestamps = FluentIterable.from(entries).transform((Function)new Function<DBSearchIndexQueueEntry, DateTime>(){

            public DateTime apply(DBSearchIndexQueueEntry input) {
                return new DateTime((Object)input.getCreatedAt());
            }
        }).toList();
        this._queueStatisticsService.itemsDequeued(QueueName.SEARCH_INDEX, (Iterable<DateTime>)timestamps);
    }

    private void indexQueueEntries(@Nonnull ImmutableSet<DBSearchIndexQueueEntry> entries) throws SolrRequestException {
        LOG.info("Processing index queue entries...");
        ImmutableSetMultimap entriesMultimap = (ImmutableSetMultimap)entries.stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(DBSearchIndexQueueEntry::getSearchableId, DBSearchIndexQueueEntry::getIndexType));
        this._searchService.updateIndexOf((SetMultimap<SearchableId, SearchIndexType>)entriesMultimap, true);
        LOG.info("Processing index queue finish!");
    }

    @Override
    public void fullImport(Set<FilterType> filterTypes, boolean deleteFirst) throws ServiceException {
        if (deleteFirst) {
            this._searchService.deleteFromSearchIndex(filterTypes);
        }
        this.deleteEntriesOfTypeFromQueue(filterTypes);
        final ImmutableSet.Builder entityTypes = ImmutableSet.builder();
        FilterTypeVisitor<Optional<Void>> indexQueueVisitor = new FilterTypeVisitor<Optional<Void>>(){

            @Override
            public Optional<Void> visitDefault() {
                return Optional.absent();
            }

            @Override
            public Optional<Void> visitProfiles() {
                SearchIndexServiceImpl.this._indexQueueDAO.insertAllProfiles();
                return Optional.absent();
            }

            @Override
            public Optional<Void> visitEntity(EntityType entityType) {
                entityTypes.add((Object)entityType);
                return Optional.absent();
            }

            @Override
            public Optional<Void> visitMicroblogs() {
                SearchIndexServiceImpl.this._indexQueueDAO.insertAllMicroblogs();
                return Optional.absent();
            }
        };
        for (FilterType type : filterTypes) {
            type.accept(indexQueueVisitor);
        }
        this._indexQueueDAO.insertEntriesForEntityType((Set<EntityType>)entityTypes.build());
    }

    private void deleteEntriesOfTypeFromQueue(@Nonnull Set<FilterType> filterTypes) {
        final ImmutableSet.Builder itemTypeBuilder = ImmutableSet.builder();
        final ImmutableSet.Builder entityTypeBuilder = ImmutableSet.builder();
        for (FilterType filterType : filterTypes) {
            filterType.accept(new FilterTypeVisitor<Optional<Void>>(){

                @Override
                @Nonnull
                public Optional<Void> visitDefault() {
                    return Optional.absent();
                }

                @Override
                public Optional<Void> visitAll() {
                    itemTypeBuilder.addAll((Iterable)ImmutableSet.copyOf((Object[])ItemType.values()));
                    return Optional.absent();
                }

                @Override
                public Optional<Void> visitNewsPosts() {
                    itemTypeBuilder.add((Object)ItemType.POST);
                    return Optional.absent();
                }

                @Override
                public Optional<Void> visitProfiles() {
                    itemTypeBuilder.add((Object)ItemType.PROFILE);
                    return Optional.absent();
                }

                @Override
                public Optional<Void> visitEntity(EntityType entityType) {
                    entityTypeBuilder.add((Object)entityType);
                    return Optional.absent();
                }

                @Override
                public Optional<Void> visitMicroblogs() {
                    itemTypeBuilder.add((Object)ItemType.WORKSTREAM_MESSAGE);
                    return Optional.absent();
                }
            });
        }
        this._indexQueueDAO.deleteByItemType((Set<ItemType>)itemTypeBuilder.build());
        this._indexQueueDAO.deleteByEntityType((Set<EntityType>)entityTypeBuilder.build());
    }

    @Override
    public long getQueueSize() {
        return this._indexQueueDAO.getQueueSize();
    }
}

