/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.searchnew.business.BasicSearchService;
import de.justsoftware.onx.searchnew.business.CommonSearchService;
import de.justsoftware.onx.searchnew.business.SearchDispatcherService;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderId;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchDispatcherServiceImpl
implements SearchDispatcherService {
    private final CommonSearchService _jucoSearchService;
    private final I18nService _i18nService;
    private ImmutableMap<SearchProviderId, BasicSearchService> _searchProviderMap;
    private ImmutableList<SearchProvider> _providerModelList;

    @Autowired
    @ParametersAreNonnullByDefault
    public SearchDispatcherServiceImpl(CommonSearchService commonSearchService, I18nService i18nService) {
        this._jucoSearchService = commonSearchService;
        this._i18nService = i18nService;
    }

    @Override
    public SearchResult<FederatedSearchResultEntry> search(SearchParameters parameter, int offset, int numberOfResults, String searchTrackingId, SearchAuthorizationCheckContext authorizationContext) throws InvalidIDException {
        return this.getSearchService(parameter.getSearchProvider()).search(parameter, offset, numberOfResults, searchTrackingId, authorizationContext);
    }

    @Override
    public ImmutableSet<SearchProviderId> getProviderSet() {
        return this._searchProviderMap.keySet();
    }

    @Override
    public ImmutableList<SearchProvider> getProviderModelList() {
        return this._providerModelList;
    }

    @Nonnull
    private BasicSearchService getSearchService(@Nonnull SearchProviderId providerId) throws InvalidIDException {
        BasicSearchService searchService = (BasicSearchService)this._searchProviderMap.get((Object)providerId);
        if (searchService == null) {
            throw new InvalidIDException(providerId);
        }
        return searchService;
    }

    @Resource(name="searchProviderList")
    public void setSearchProviderList(@Nonnull List<BasicSearchService> searchProviderList) {
        SearchProviderId jucoSearchId;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BasicSearchService service : searchProviderList) {
            builder.put((Object)service.getSearchProvider().getId(), (Object)service);
        }
        ImmutableMap configuredProvidersMap = builder.build();
        this._searchProviderMap = configuredProvidersMap.containsKey((Object)(jucoSearchId = this._jucoSearchService.getSearchProvider().getId())) ? configuredProvidersMap : ImmutableMap.builder().put((Object)jucoSearchId, (Object)this._jucoSearchService).putAll((Map)configuredProvidersMap).build();
        this._i18nService.initSearchProviderSpecificMessages((ImmutableSet<SearchProviderId>)this._searchProviderMap.keySet());
        ImmutableList.Builder providerModelListBuilder = ImmutableList.builder();
        for (BasicSearchService service : this._searchProviderMap.values()) {
            providerModelListBuilder.add((Object)service.getSearchProvider());
        }
        this._providerModelList = providerModelListBuilder.build();
    }
}

