/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.Roles;
import de.justsoftware.onx.authorization.business.StaticPermissionRole;
import de.justsoftware.onx.authorization.business.StaticPredefinedRole;
import de.justsoftware.onx.authorization.business.StaticRole;
import de.justsoftware.onx.common.shared.model.Authority;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.StartpageId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.business.EntityAdministrationWorkflowService;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import de.justsoftware.onx.person.business.FriendsService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.searchnew.business.RolesSearchService;
import de.justsoftware.onx.tasks.authorization.TaskRole;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class RolesSearchServiceImpl
implements RolesSearchService {
    private static final Logger LOG = LoggerFactory.getLogger(RolesSearchServiceImpl.class);
    private static final ImmutableSet<StaticPredefinedRole> ALL_LOGGED_IN = ImmutableSet.of((Object)StaticPredefinedRole.ALL, (Object)StaticPredefinedRole.LOGGED_IN);
    private static final Role.RoleVisitor<Boolean> ITEM_DEPENDANT_ROLE_VISITOR = new Role.DefaultRoleVisitor<Boolean>(){

        @Override
        public Boolean visitAll(StaticRole staticRole) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitLoggedIn(StaticRole staticRole) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitDefault(StaticRole staticRole) {
            return Boolean.TRUE;
        }
    };
    @Autowired
    private PersonService _personService;
    @Autowired
    private FriendsService _friendsService;
    @Autowired
    private EntityMemberService _entityMemberService;
    @Autowired
    private EntityAdministrationWorkflowService _entityAdministrationService;
    @Autowired
    private EntityVersionService _entityVersionService;
    @Autowired
    private EntityService _entityService;
    private final PermissionRequestConnector _permissionRequestConnector;

    @Autowired
    public RolesSearchServiceImpl(PermissionRequestConnector permissionRequestConnector) {
        this._permissionRequestConnector = permissionRequestConnector;
    }

    @Override
    public ImmutableSet<String> getStaticUserRolesForSearchQuery(PersonId personId) {
        return (ImmutableSet)this._permissionRequestConnector.searchRoles(personId == null ? Role.notLoggedIn() : Role.profileRole((long)personId.getId())).stream().map(Role::asString).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ImmutableSet<PersonId> getPersonIdsForItemDependantRoles(final ItemId item, ImmutableSet<StaticRole> itemDependantRoles) {
        ImmutableMap<StaticRole, ImmutableSetMultimap<ItemId, PersonId>> result = this.getPersonIdsForItemDependantRoles((ImmutableSetMultimap<? extends ItemId, ? extends de.justsoftware.onx.common.shared.model.Role>)ImmutableSetMultimap.builder().putAll((Object)item, itemDependantRoles).build());
        return FluentIterable.from(itemDependantRoles).transform(Functions.forMap(result, (Object)ImmutableSetMultimap.of())).transformAndConcat((Function)new NullPermeableFunction<ImmutableSetMultimap<ItemId, PersonId>, Iterable<PersonId>>(){

            @Override
            protected Iterable<PersonId> applySafe(ImmutableSetMultimap<ItemId, PersonId> input) {
                return input.get((Object)item);
            }
        }).toSet();
    }

    @Override
    public ImmutableMap<StaticRole, ImmutableSetMultimap<ItemId, PersonId>> getPersonIdsForItemDependantRoles(ImmutableSetMultimap<? extends ItemId, ? extends de.justsoftware.onx.common.shared.model.Role> roles) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry roleEntry : roles.inverse().asMap().entrySet()) {
            de.justsoftware.onx.common.shared.model.Role role = (de.justsoftware.onx.common.shared.model.Role)roleEntry.getKey();
            if (!(role instanceof StaticRole)) continue;
            ImmutableSetMultimap.Builder resultForRole = ImmutableSetMultimap.builder();
            Collection ids = (Collection)roleEntry.getValue();
            ImmutableSet entities = FluentIterable.from((Iterable)ids).filter(EntityId.class).toSet();
            Sets.SetView persons = Sets.union((Set)FluentIterable.from((Iterable)ids).filter(ProfileId.class).transform(ProfileId.TO_PERSON_ID).toSet(), (Set)FluentIterable.from((Iterable)ids).filter(StartpageId.class).transform(StartpageId.TO_PERSON_ID).toSet());
            resultForRole.putAll(((StaticRole)role).accept(new AuthorizedPersonByItemDependentRoleVisitor((Set<EntityId>)entities, (Set<PersonId>)persons)));
            result.put((Object)((StaticRole)role), (Object)resultForRole.build());
        }
        return result.build();
    }

    @Nonnull
    public static ImmutableSet<de.justsoftware.onx.common.shared.model.Role> getStaticRoles(@Nullable Multimap<Action, ? extends de.justsoftware.onx.common.shared.model.Role> source, Iterable<? extends Action> actions) {
        ImmutableSet<de.justsoftware.onx.common.shared.model.Role> authoritiesByActions = RolesSearchServiceImpl.getAuthoritiesByActions(source, actions);
        if (authoritiesByActions.contains((Object)StaticPredefinedRole.ALL)) {
            return ImmutableSet.of((Object)StaticPredefinedRole.ALL);
        }
        if (authoritiesByActions.contains((Object)StaticPredefinedRole.LOGGED_IN)) {
            return ImmutableSet.of((Object)StaticPredefinedRole.LOGGED_IN);
        }
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (de.justsoftware.onx.common.shared.model.Role auth : authoritiesByActions) {
            if (!(auth instanceof StaticRole)) {
                resultBuilder.add((Object)auth);
                continue;
            }
            if (((StaticRole)auth).accept(ITEM_DEPENDANT_ROLE_VISITOR).booleanValue()) continue;
            resultBuilder.add((Object)auth);
        }
        return resultBuilder.build();
    }

    @Nonnull
    public static ImmutableSet<StaticRole> getItemDependantRoles(@Nullable Multimap<Action, ? extends de.justsoftware.onx.common.shared.model.Role> source, Iterable<? extends Action> actions) {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (Authority auth : RolesSearchServiceImpl.getAuthoritiesByActions(source, actions)) {
            if (ALL_LOGGED_IN.contains((Object)auth)) {
                return ImmutableSet.of();
            }
            if (!(auth instanceof StaticRole) || !((StaticRole)auth).accept(ITEM_DEPENDANT_ROLE_VISITOR).booleanValue()) continue;
            resultBuilder.add((Object)((StaticRole)auth));
        }
        return resultBuilder.build();
    }

    @Nonnull
    private static ImmutableSet<de.justsoftware.onx.common.shared.model.Role> getAuthoritiesByActions(@Nullable Multimap<Action, ? extends de.justsoftware.onx.common.shared.model.Role> source, Iterable<? extends Action> actions) {
        if (source == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder auths = ImmutableSet.builder();
        for (Action action : actions) {
            auths.addAll((Iterable)source.get((Object)action));
        }
        return auths.build();
    }

    private class AuthorizedPersonByItemDependentRoleVisitor
    implements Role.RoleVisitor<Multimap<? extends ItemId, PersonId>> {
        private final Set<EntityId> _entities;
        private final Set<PersonId> _persons;

        public AuthorizedPersonByItemDependentRoleVisitor(@Nonnull Set<EntityId> entities, Set<PersonId> persons) {
            this._entities = entities;
            this._persons = persons;
        }

        private void notForEntities(@Nonnull StaticRole staticRole) {
            if (!this._entities.isEmpty()) {
                LOG.warn("StaticRole \"{}\" should not be used for Entities {}!", (Object)staticRole, this._entities);
            }
        }

        private void notForPerson(@Nonnull StaticRole staticRole) {
            if (!this._persons.isEmpty()) {
                LOG.warn("StaticRole \"{}\" should not be used for Person {}!", (Object)staticRole, this._persons);
            }
        }

        private void wrongPersonRoleUsed(@Nonnull StaticRole staticRole) {
            if (!this._persons.isEmpty()) {
                LOG.warn("StaticRole \"{}\" was used, but can't be handled for persons {}!", (Object)staticRole, this._persons);
            }
        }

        @Override
        public final Multimap<GlobalId, PersonId> visitAll(StaticRole staticRole) {
            return this.staticRole();
        }

        @Nonnull
        private Multimap<GlobalId, PersonId> staticRole() {
            return ImmutableSetMultimap.of();
        }

        @Override
        public final Multimap<GlobalId, PersonId> visitLoggedIn(StaticRole staticRole) {
            return this.staticRole();
        }

        @Override
        public final Multimap<GlobalId, PersonId> visitSurveyParticipant(StaticRole staticRole) {
            this.notForEntities(staticRole);
            this.notForPerson(staticRole);
            return ImmutableSetMultimap.of();
        }

        @Override
        public final Multimap<GlobalId, PersonId> visitUnsubscriber(StaticRole staticRole) {
            return this.staticRole();
        }

        @Override
        public Multimap<GlobalId, PersonId> visitPersonFriend(StaticRole staticRole) {
            this.notForEntities(staticRole);
            return this.transformPersonMultimap(RolesSearchServiceImpl.this._friendsService.getFriendIdsOfPersons(this._persons));
        }

        @Nonnull
        private ImmutableSetMultimap<GlobalId, PersonId> transformPersonMultimap(@Nonnull ImmutableSetMultimap<PersonId, PersonId> map) {
            ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
            for (Map.Entry entry : map.asMap().entrySet()) {
                Collection value = (Collection)entry.getValue();
                PersonId key = (PersonId)entry.getKey();
                result.putAll((Object)key.asProfileId(), (Iterable)value);
                result.putAll((Object)key.asStartpageId(), (Iterable)value);
            }
            return result.build();
        }

        @Override
        public Multimap<GlobalId, PersonId> visitPersonMemberOfSameEntity(StaticRole staticRole) {
            this.notForEntities(staticRole);
            return this.transformPersonMultimap(RolesSearchServiceImpl.this._entityMemberService.getMembersOfSameEntityOfPersons(this._persons));
        }

        @Override
        public Multimap<GlobalId, PersonId> visitAdmin(StaticRole staticRole) {
            return ImmutableSetMultimap.builder().putAll(this.entityAdminPersons()).putAll(this.profileOwnerPersons()).build();
        }

        @Nonnull
        private Multimap<EntityId, PersonId> getPersonByEntityMemberStatus(@Nonnull StaticRole role) {
            return this.visitEntityMemberRolesByFilter(EntityMemberUtil.composeRoleFilterPredicate((Set<EntityMemberRole>)Roles.STATIC_ROLE_MAPPING.get((Object)role)));
        }

        @Nonnull
        private Multimap<EntityId, PersonId> visitEntityMemberRolesByFilter(@Nonnull Predicate<EntityMember> filter) {
            return Multimaps.transformValues((Multimap)Multimaps.filterValues(RolesSearchServiceImpl.this._entityMemberService.getEntityMembersByEntityIds(this._entities), filter), EntityMember.GET_PERSON_ID);
        }

        @Nonnull
        private Multimap<EntityId, PersonId> visitStaticEntityMemberRole(@Nonnull StaticRole role) {
            this.notForPerson(role);
            return this.getPersonByEntityMemberStatus(role);
        }

        @Override
        public Multimap<EntityId, PersonId> visitEntityMember(StaticRole staticRole) {
            return this.visitStaticEntityMemberRole(staticRole);
        }

        @Override
        public ImmutableSetMultimap<EntityId, PersonId> visitEntityMemberOfParent(StaticRole staticRole) {
            this.notForPerson(staticRole);
            return RolesSearchServiceImpl.this._entityMemberService.getInheritedMembers(InheritsRole.INHERIT_MEMBERS, this._entities);
        }

        @Override
        public ImmutableSetMultimap<EntityId, PersonId> visitEntityAdminOfParent(StaticRole staticRole) {
            this.notForPerson(staticRole);
            return RolesSearchServiceImpl.this._entityMemberService.getInheritedMembers(InheritsRole.INHERIT_ADMINS, this._entities);
        }

        @Override
        public Multimap<EntityId, PersonId> visitEntityHasRejected(StaticRole staticRole) {
            return this.visitStaticEntityMemberRole(staticRole);
        }

        @Override
        public Multimap<EntityId, PersonId> visitEntityHasSentJoinRequest(StaticRole staticRole) {
            return this.visitStaticEntityMemberRole(staticRole);
        }

        @Override
        public Multimap<EntityId, PersonId> visitEntityUndecided(StaticRole staticRole) {
            return this.visitStaticEntityMemberRole(staticRole);
        }

        @Override
        public Multimap<EntityId, PersonId> visitEntityHasInvitation(StaticRole staticRole) {
            return this.visitStaticEntityMemberRole(staticRole);
        }

        @Override
        public Multimap<EntityId, PersonId> visitHasNoEventStatus(StaticRole staticRole) {
            this.notForPerson(staticRole);
            return this.visitEntityMemberRolesByFilter((Predicate<EntityMember>)Predicates.not(EntityMemberUtil.composeRoleFilterPredicate(EntityMemberRoles.ALL_EVENT_STATUS)));
        }

        @Override
        public Multimap<EntityId, PersonId> visitIsAttendingTheEvent(StaticRole staticRole) {
            return this.visitStaticEntityMemberRole(staticRole);
        }

        @Override
        public Multimap<EntityId, PersonId> visitIsNotAttendingTheEvent(StaticRole staticRole) {
            return this.visitStaticEntityMemberRole(staticRole);
        }

        @Override
        public Multimap<EntityId, PersonId> visitIsMaybeAttendingTheEvent(StaticRole staticRole) {
            return this.visitStaticEntityMemberRole(staticRole);
        }

        @Override
        public Multimap<EntityId, PersonId> visitIsOnWaitinglistForEvent(StaticRole staticRole) {
            return this.visitStaticEntityMemberRole(staticRole);
        }

        @Override
        public Multimap<EntityId, PersonId> visitIsInvitedToEvent(StaticRole staticRole) {
            return this.visitStaticEntityMemberRole(staticRole);
        }

        @Override
        public Multimap<EntityId, PersonId> visitHasRejectedTheEventInvitation(StaticRole staticRole) {
            return this.visitStaticEntityMemberRole(staticRole);
        }

        @Override
        public Multimap<GlobalId, PersonId> visitPersonHasInvited(StaticRole staticRole) {
            this.notForEntities(staticRole);
            this.wrongPersonRoleUsed(staticRole);
            return ImmutableSetMultimap.of();
        }

        @Override
        public Multimap<GlobalId, PersonId> visitPersonHasInvitation(StaticRole staticRole) {
            this.notForEntities(staticRole);
            this.wrongPersonRoleUsed(staticRole);
            return ImmutableSetMultimap.of();
        }

        @Override
        public Multimap<EntityId, PersonId> visitCoAdmin(StaticRole staticRole) {
            return this.visitEntityCoAdmin(StaticPredefinedRole.ENTITY_CO_ADMIN);
        }

        @Override
        public ImmutableSetMultimap<EntityId, PersonId> visitEntityVersionReviewer(StaticRole staticRole) {
            this.notForPerson(staticRole);
            return RolesSearchServiceImpl.this._entityVersionService.getEntityVersionReviewer(this._entities);
        }

        @Nonnull
        private Multimap<? extends GlobalId, PersonId> profileOwnerPersons() {
            ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
            for (PersonId personId : this._persons) {
                result.put((Object)personId.asProfileId(), (Object)personId);
                result.put((Object)personId.asStartpageId(), (Object)personId);
            }
            return result.build();
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitProfileOwner(StaticRole staticRole) {
            this.notForEntities(staticRole);
            return this.profileOwnerPersons();
        }

        @Nonnull
        private Multimap<? extends GlobalId, PersonId> entityAdminPersons() {
            return this.getPersonByEntityMemberStatus(StaticPredefinedRole.ENTITY_ADMIN);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitEntityAdmin(StaticRole staticRole) {
            this.notForPerson(staticRole);
            return this.entityAdminPersons();
        }

        @Override
        public Multimap<EntityId, PersonId> visitEntityCoAdmin(StaticRole staticRole) {
            this.notForPerson(staticRole);
            return RolesSearchServiceImpl.this._entityAdministrationService.getDirectAdminsAndCoAdmins(this._entities);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitWorkstreamMessageAuthor(StaticRole staticRole) {
            return ImmutableSetMultimap.of();
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitWikiVersionAuthor(StaticRole staticRole) {
            return this.notForPersonOrEntity(staticRole);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitWikiBackupAuthor(StaticRole staticRole) {
            return this.notForPersonOrEntity(staticRole);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitVieolinkAuthor(StaticRole staticRole) {
            return this.notForPersonOrEntity(staticRole);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitSurveyOwner(StaticRole staticRole) {
            return this.notForPersonOrEntity(staticRole);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitDocumentVersionAuthor(StaticRole staticRole) {
            return this.notForPersonOrEntity(staticRole);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitDocumentOwnerOfAllVersions(StaticRole staticRole) {
            return this.notForPersonOrEntity(staticRole);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitCommentAuthor(StaticRole staticRole) {
            return this.notForPersonOrEntity(staticRole);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitAlbumImageOwner(StaticRole staticRole) {
            return this.notForPersonOrEntity(staticRole);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitAlbumOwner(StaticRole staticRole) {
            return this.notForPersonOrEntity(staticRole);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitEntityAssignee(StaticRole staticRole) {
            this.notForPerson(staticRole);
            return Multimaps.forMap((Map)Maps.filterValues((Map)Maps.transformValues(RolesSearchServiceImpl.this._entityService.getByIds(this._entities), (Function)new NullPermeableFunction<DBEntity, PersonId>(){

                @Override
                public PersonId applySafe(DBEntity input) {
                    return input.getAssignee();
                }
            }), (Predicate)Predicates.notNull()));
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitTaskListEditor(TaskRole role) {
            return this.notForPersonOrEntity(role);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitTaskListManager(TaskRole role) {
            return this.notForPersonOrEntity(role);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitTaskListReader(TaskRole role) {
            return this.notForPersonOrEntity(role);
        }

        @Nonnull
        private Multimap<? extends GlobalId, PersonId> notForPersonOrEntity(@Nonnull StaticRole staticRole) {
            this.notForPerson(staticRole);
            this.notForEntities(staticRole);
            return ImmutableSetMultimap.of();
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitTaskAssignee(TaskRole role) {
            return this.notForPersonOrEntity(role);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitTaskAssigneeOfSubtask(TaskRole role) {
            return this.notForPersonOrEntity(role);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitTaskOwner(TaskRole role) {
            return this.notForPersonOrEntity(role);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitTaskOwnerOfSubtask(TaskRole role) {
            return this.notForPersonOrEntity(role);
        }

        @Override
        public Multimap<? extends GlobalId, PersonId> visitPermissionRole(StaticPermissionRole role) {
            return this.notForPersonOrEntity(role);
        }
    }
}

