/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.server.util.HtmlUtil;
import de.justsoftware.onx.container.shared.model.DefaultItemIdVisitor;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.NewsChannelId;
import de.justsoftware.onx.container.shared.model.NewsPostId;
import de.justsoftware.onx.searchnew.business.impl.AbstractSearchHandler;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchResultModel;
import de.justsoftware.onx.searchnew.shared.model.CompoundIdStringUtil;
import de.justsoftware.onx.searchnew.shared.model.NewsPostSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.NewsPostSuggest;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class NewsPostSearchHandler
extends AbstractSearchHandler<NewsPostId, ItemType> {
    @Override
    protected NewsPostId createId(String stringId) {
        return new NewsPostId(CompoundIdStringUtil.parseStringId(stringId));
    }

    @Override
    protected boolean canHandle(@Nonnull Type type) {
        return ItemType.POST == type;
    }

    @Nonnull
    public ImmutableMap<CompoundId, NewsPostSearchResultBadgeModel> createSearchResultBadgeModel(@Nonnull Iterable<? extends CommonSearchResultModel> searchResultModels) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (CommonSearchResultModel commonSearchResultModel : searchResultModels) {
            NewsPostSearchResultBadgeModel badgeModel = this.createSearchResultBadgeModel(commonSearchResultModel);
            result.put((Object)CompoundId.of((NewsPostId)badgeModel.getId()), (Object)badgeModel);
        }
        return result.build();
    }

    @Nonnull
    public ImmutableMap<CompoundId, NewsPostSuggest> createSearchResultSuggestModel(@Nonnull Iterable<? extends CommonSearchResultModel> searchResultModels) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (CommonSearchResultModel commonSearchResultModel : searchResultModels) {
            NewsPostSuggest suggest = this.createSearchResultSuggestModel(commonSearchResultModel);
            result.put((Object)CompoundId.of((NewsPostId)suggest.getId()), (Object)suggest);
        }
        return result.build();
    }

    @Nonnull
    private NewsPostSearchResultBadgeModel createSearchResultBadgeModel(final CommonSearchResultModel searchResultModel) {
        final NewsPostSearchResultBadgeModel result = new NewsPostSearchResultBadgeModel();
        result.setId(this.createId(searchResultModel.getId()));
        result.setType(ItemType.POST);
        result.setCommonFields(searchResultModel);
        result.setName(searchResultModel.getNameSubstring());
        searchResultModel.getParentIds().stream().findFirst().ifPresent(stringItemId -> {
            ItemId itemId = ItemId.parse(stringItemId);
            if (itemId != null) {
                itemId.accept(new DefaultItemIdVisitor<Optional<Void>>(){

                    @Override
                    public Optional<Void> visitDefault(@Nonnull ItemId itemId) {
                        return Optional.empty();
                    }

                    @Override
                    public Optional<Void> visit(NewsChannelId channelId) {
                        result.setChannelId(channelId);
                        result.setChannelTitle(searchResultModel.getParentName());
                        return Optional.empty();
                    }
                });
            }
        });
        return result;
    }

    @Nonnull
    private NewsPostSuggest createSearchResultSuggestModel(CommonSearchResultModel searchResultModel) {
        NewsPostSuggest suggest = new NewsPostSuggest();
        this.applySearchData(searchResultModel, ItemType.POST, suggest);
        suggest.setName(HtmlUtil.removeHighlightTag(searchResultModel.getName()));
        return suggest;
    }
}

