/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.server.util.HtmlUtil;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.NewsChannelId;
import de.justsoftware.onx.searchnew.business.impl.AbstractSearchHandler;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchResultModel;
import de.justsoftware.onx.searchnew.shared.model.CompoundIdStringUtil;
import de.justsoftware.onx.searchnew.shared.model.NewsChannelSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.NewsChannelSuggest;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Service;

@Service
public class NewsChannelSearchHandler
extends AbstractSearchHandler<NewsChannelId, ItemType> {
    @Override
    protected NewsChannelId createId(String stringId) {
        return new NewsChannelId(CompoundIdStringUtil.parseStringId(stringId));
    }

    @Override
    protected boolean canHandle(@Nonnull Type type) {
        return ItemType.CHANNEL == type;
    }

    @Nonnull
    public ImmutableMap<CompoundId, NewsChannelSearchResultBadgeModel> createSearchResultBadgeModel(@Nonnull Iterable<? extends CommonSearchResultModel> searchResultModels) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (CommonSearchResultModel commonSearchResultModel : searchResultModels) {
            NewsChannelSearchResultBadgeModel badgeModel = this.createSearchResultBadgeModel(commonSearchResultModel);
            result.put((Object)CompoundId.of((NewsChannelId)badgeModel.getId()), (Object)badgeModel);
        }
        return result.build();
    }

    @Nonnull
    public ImmutableMap<CompoundId, NewsChannelSuggest> createSearchResultSuggestModel(@Nonnull Iterable<? extends CommonSearchResultModel> searchResultModels) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (CommonSearchResultModel commonSearchResultModel : searchResultModels) {
            NewsChannelSuggest suggest = this.createSearchResultSuggestModel(commonSearchResultModel);
            result.put((Object)CompoundId.of((NewsChannelId)suggest.getId()), (Object)suggest);
        }
        return result.build();
    }

    @Nonnull
    private NewsChannelSearchResultBadgeModel createSearchResultBadgeModel(CommonSearchResultModel searchResultModel) {
        NewsChannelSearchResultBadgeModel result = new NewsChannelSearchResultBadgeModel();
        result.setId(this.createId(searchResultModel.getId()));
        result.setType(ItemType.CHANNEL);
        result.setCommonFields(searchResultModel);
        result.setName(searchResultModel.getNameSubstring());
        return result;
    }

    @Nonnull
    private NewsChannelSuggest createSearchResultSuggestModel(CommonSearchResultModel searchResultModel) {
        NewsChannelSuggest suggest = new NewsChannelSuggest();
        this.applySearchData(searchResultModel, ItemType.CHANNEL, suggest);
        suggest.setName(HtmlUtil.removeHighlightTag(searchResultModel.getName()));
        suggest.setModifyDate(searchResultModel.getModifyDate());
        return suggest;
    }
}

