/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.configfile.ConfFile;
import de.justsoftware.onx.common.business.configfile.ConfigFileChangeEvent;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.business.LearnToRankService;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.searchnew.business.model.LTRFeatureConfig;
import de.justsoftware.onx.searchnew.shared.model.LearnToRankToggleValue;
import de.justsoftware.onx.searchnew.shared.model.LearnToRankTriggerResult;
import de.justsoftware.onx.server.business.ClusterConfiguration;
import de.justsoftware.onx.util.server.RequestBuilder;
import de.justsoftware.onx.zookeeper.LTRSearchConfiguration;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

@Service(value="learnToRankService")
@ParametersAreNonnullByDefault
public class LearnToRankServiceImpl
implements LearnToRankService,
ServerEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LearnToRankServiceImpl.class);
    private final ConfigFileService _configFileService;
    private final LTRSearchConfiguration _ltrSearchConfiguration;
    private final RestOperations _restOperations;
    private final Settings _settings;
    private final ClusterConfiguration _clusterConfiguration;

    @Autowired
    public LearnToRankServiceImpl(ConfigFileService configFileService, LTRSearchConfiguration ltrSearchConfiguration, @Qualifier(value="defaultRestTemplate") RestOperations restOperations, Settings settings, ClusterConfiguration clusterConfiguration) {
        this._configFileService = configFileService;
        this._ltrSearchConfiguration = ltrSearchConfiguration;
        this._restOperations = restOperations;
        this._settings = settings;
        this._clusterConfiguration = clusterConfiguration;
    }

    @Override
    public ImmutableMap<String, String> getExternalFeatureInformation(PersonId personId, String query) {
        return ImmutableMap.of((Object)"userQuery", (Object)query, (Object)"userId", (Object)CompoundId.ofSearchableId(personId).toSearchString());
    }

    @Override
    public LTRFeatureConfig getLTRFeatureConfig() {
        ConfFile config = this._configFileService.getConfigFile();
        return new LTRFeatureConfig((ImmutableSet<String>)((ImmutableSet)config.getEntityTypes().stream().map(EntityType::getName).collect(ImmutableSet.toImmutableSet())));
    }

    @Override
    public LearnToRankTriggerResult startTraining() {
        return this.triggerAction("/train");
    }

    @Override
    public LearnToRankTriggerResult resetFeaturesAndModels() {
        return this.triggerAction("/reset");
    }

    @Override
    public LearnToRankTriggerResult updateUpcomingFeatures() throws ServiceException {
        return this.triggerAction("/updateUpcoming");
    }

    @Nonnull
    private LearnToRankTriggerResult triggerAction(String actionPath) {
        if (this._settings.getLearnToRankEnabled() == LearnToRankToggleValue.DISABLED) {
            return new LearnToRankTriggerResult(false, "The learn to rank feature is disabled.");
        }
        String baseUrl = this._ltrSearchConfiguration.getJustSearchLtrServiceEndpointUrl();
        if (Strings.isNullOrEmpty((String)baseUrl)) {
            throw new ServiceException("URL of search-ltr service not available.");
        }
        try {
            ResponseEntity<LearnToRankTriggerResult> responseEntity = new RequestBuilder<LearnToRankTriggerResult>(LearnToRankTriggerResult.class).url(baseUrl + actionPath).headers((Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json;charset=UTF-8")).post(null).execute(this._restOperations);
            HttpStatus status = responseEntity.getStatusCode();
            if (status != HttpStatus.OK) {
                throw new ServiceException("Error calling search-ltr, status: " + status.value() + "(" + status.getReasonPhrase() + ")");
            }
            return (LearnToRankTriggerResult)responseEntity.getBody();
        }
        catch (RestClientException e) {
            throw new ServiceException("Error calling search-ltr", e);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onConfigFileChangeEvent(ConfigFileChangeEvent event) {
        LOG.info("Config file changed, updating upcoming feature store.");
        this.updateUpcomingFeatures();
    }
}

