/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrInputDocument;

@ParametersAreNonnullByDefault
public abstract class JucoSolrInputDocument {
    static final Function<JucoSolrInputDocument, SolrInputDocument> TO_SOLR_INPUT_DOCUMENT = new NullPermeableFunction<JucoSolrInputDocument, SolrInputDocument>(){

        @Override
        protected SolrInputDocument applySafe(JucoSolrInputDocument input) {
            return input._doc;
        }
    };
    protected final SolrInputDocument _doc = new SolrInputDocument(new String[0]);

    private JucoSolrInputDocument(SearchableId id) {
        this._doc.addField("id", (Object)CompoundId.ofSearchableId(id).toSearchString());
    }

    protected abstract void addFieldInternal(String var1, @Nullable Object var2);

    public abstract void atomicAddField(SearchField var1, @Nullable Object var2);

    public final void addField(SearchField name, Iterable<?> value) {
        this.addFieldInternal(name.getFieldName(), Iterables.isEmpty(value) ? null : value);
    }

    public final void addField(SearchField name, @Nullable String value) {
        this.addFieldInternal(name.getFieldName(), StringUtils.defaultIfBlank((String)value, null));
    }

    public final void addField(SearchField name, Optional<?> value) {
        this.addFieldInternal(name.getFieldName(), value.orNull());
    }

    public abstract void addWildcardField(Map<String, ?> var1);

    @Nonnull
    public static JucoSolrInputDocument full(SearchableId id) {
        return new JucoSolrInputDocument(id){

            @Override
            protected void addFieldInternal(String name, @Nullable Object value) {
                this._doc.addField(name, value);
            }

            @Override
            public void addWildcardField(Map<String, ?> map) {
                for (Map.Entry<String, ?> entry : map.entrySet()) {
                    this._doc.addField(entry.getKey(), entry.getValue());
                }
            }

            @Override
            public void atomicAddField(SearchField name, Object value) {
                throw new NotImplementedException("Atomic add is not supported by full index documents");
            }
        };
    }

    @Nonnull
    public static JucoSolrInputDocument atomic(SearchableId id) {
        return new JucoSolrInputDocument(id){

            @Override
            protected void addFieldInternal(String name, Object value) {
                this._doc.addField(name, Collections.singletonMap("set", value));
            }

            @Override
            public void addWildcardField(Map<String, ?> map) {
                throw new UnsupportedOperationException("atomic update on wildcard fields are currently not supported because you have to delete existing keys");
            }

            @Override
            public void atomicAddField(SearchField name, Object value) {
                this._doc.addField(name.getFieldName(), Collections.singletonMap("add", value));
            }
        };
    }

    @Nonnull
    public SolrInputDocument getDoc() {
        return this._doc;
    }

    @CheckForNull
    @VisibleForTesting
    public Object getFieldValue(SearchField field) {
        return this._doc.getFieldValue(field.getFieldName());
    }

    @Nonnull
    @VisibleForTesting
    public Set<?> getFieldValues(SearchField field) {
        Collection result = this._doc.getFieldValues(field.getFieldName());
        if (result == null || result.isEmpty()) {
            return ImmutableSet.of();
        }
        if (result instanceof Set) {
            return (Set)result;
        }
        return Sets.newHashSet((Iterable)result);
    }

    public String toString() {
        return this._doc.toString();
    }
}

