/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JucoSolrClientConfiguration {
    @Autowired
    @Value(value="${SOLR.readCommonUrl}")
    private String _readUrl;
    @Autowired
    @Value(value="${SOLR.writeCommonUrl}")
    private String _writeUrl;
    private SolrClient _writeSolrClient;
    private SolrClient _readSolrClient;

    @PostConstruct
    public void init() {
        this._writeSolrClient = this.createWriteSolrClient();
        this._readSolrClient = this.createReadSolrClient();
    }

    @CheckForNull
    private SolrClient createReadSolrClient() {
        if (this._writeUrl.equals(this._readUrl)) {
            return null;
        }
        return new HttpSolrClient.Builder(this._readUrl).build();
    }

    @Nonnull
    private SolrClient createWriteSolrClient() {
        return new HttpSolrClient.Builder(this._writeUrl).build();
    }

    @Bean(name={"writeSolrServer"})
    @Nonnull
    public SolrClient getWriteSolrClient() {
        return this._writeSolrClient;
    }

    @Bean(name={"readSolrServer"})
    @Nonnull
    public SolrClient getReadSolrClient() {
        return (SolrClient)MoreObjects.firstNonNull((Object)this._readSolrClient, (Object)this._writeSolrClient);
    }

    @PreDestroy
    public void destroy() throws IOException {
        if (this._readSolrClient != null) {
            this._readSolrClient.close();
        }
        this._writeSolrClient.close();
    }
}

