/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.searchnew.shared.model.ArchiveSubFilter;
import de.justsoftware.onx.searchnew.shared.model.BlockSubFilter;
import de.justsoftware.onx.searchnew.shared.model.CoadminSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DocumentFileTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DriveFileTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityDynamicAttributeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.EntityDynamicAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityMemberSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityStatusSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.EntityStatusSubFilter;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.InheritAdminSubFilter;
import de.justsoftware.onx.searchnew.shared.model.InheritMemberSubFilter;
import de.justsoftware.onx.searchnew.shared.model.ModificationDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.OrSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PersonIdSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PersonRoleSubFilter;
import de.justsoftware.onx.searchnew.shared.model.ProfileAttributeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.ProfileAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PublicationDateFilter;
import de.justsoftware.onx.searchnew.shared.model.SearchContextFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.searchnew.shared.model.StartAndEndDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.StartDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.SubFilterVisitor;
import de.justsoftware.onx.searchnew.shared.model.TagSubFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public enum FilterTagResolver {
    INSTANCE;

    public static final String DEFAULT_SUBFILTER_TAG = "subfilter";
    public static final String DEFAULT_CONTEXT_TAG = "context";
    public static final String DEFAULT_TYPE_TAG = "type";

    @Nonnull
    public ImmutableList<String> getSubFilterTags(@Nonnull SubFilter subfilter) {
        String subFilterSpecificTag = subfilter.accept(GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE);
        if (StringUtils.isEmpty((String)subFilterSpecificTag)) {
            return ImmutableList.of((Object)DEFAULT_SUBFILTER_TAG);
        }
        return ImmutableList.of((Object)DEFAULT_SUBFILTER_TAG, (Object)subFilterSpecificTag);
    }

    @Nonnull
    public ImmutableList<String> getFacetQueryExclusionTags(@Nonnull SearchFacet searchFacet) {
        String exclude = searchFacet.accept(GetRelatedFilterTag.FACET_INSTANCE);
        if (StringUtils.isEmpty((String)exclude)) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)exclude);
    }

    static enum GetRelatedFilterTag implements SearchFacet.SearchFacetVisitor<String>
    {
        FACET_INSTANCE;


        @Override
        public String visitDateAll(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitDateSubFilter(null);
        }

        @Override
        public String visitDateFuture(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitDateSubFilter(null);
        }

        @Override
        public String visitDatePast(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitDateSubFilter(null);
        }

        @Override
        public String visitDocumentFileType(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitDocumentFileType(null);
        }

        @Override
        public String visitModifyDateAll(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitModificationDate(null);
        }

        @Override
        public String visitModifyDateLastHour(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitModificationDate(null);
        }

        @Override
        public String visitModifyDateLast24Hours(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitModificationDate(null);
        }

        @Override
        public String visitModifyDateLastWeek(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitModificationDate(null);
        }

        @Override
        public String visitModifyDateLastMonth(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitModificationDate(null);
        }

        @Override
        public String visitModifyDateLastYear(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitModificationDate(null);
        }

        @Override
        public String visitDynamicEntityAttribute(EntityDynamicAttributeSearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitEntityDynamicAttributeSubFilter(null) + searchFacet.getDynamicAttributeId();
        }

        @Override
        public String visitArchiveAll(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitArchiveSubFilter(null);
        }

        @Override
        public String visitArchiveNonArchived(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitArchiveSubFilter(null);
        }

        @Override
        public String visitArchiveArchived(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitArchiveSubFilter(null);
        }

        @Override
        public String visitBlockAll(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitBlockedSubFilter(null);
        }

        @Override
        public String visitBlockNonBlocked(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitBlockedSubFilter(null);
        }

        @Override
        public String visitBlockBlocked(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitBlockedSubFilter(null);
        }

        @Override
        public String visitEntityStatus(EntityStatusSearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitEntityStatusSubFilter(null);
        }

        @Override
        public String visitEntityContext(SearchContextFacet.EntityBasedSearchContextFacet entityBasedSearchContextFacet) {
            return FilterTagResolver.DEFAULT_CONTEXT_TAG;
        }

        @Override
        public String visitMySubscriptions(SearchContextFacet.MySubscriptionsSearchFacet mySubscriptionsSearchFacet) {
            return FilterTagResolver.DEFAULT_CONTEXT_TAG;
        }

        @Override
        public String visitMyContent(SearchContextFacet.MyContentSearchFacet myContentSearchFacet) {
            return FilterTagResolver.DEFAULT_CONTEXT_TAG;
        }

        @Override
        public String visitMemberRole(SearchContextFacet.MemberRoleSearchFacet memberRoleSearchFacet) {
            return FilterTagResolver.DEFAULT_CONTEXT_TAG;
        }

        @Override
        public String visitAdminRole(SearchContextFacet.AdminRoleSearchFacet adminRoleSearchFacet) {
            return FilterTagResolver.DEFAULT_CONTEXT_TAG;
        }

        @Override
        public String visitAllContent(SearchContextFacet.AllContentSearchFacet allContentSearchFacet) {
            return FilterTagResolver.DEFAULT_CONTEXT_TAG;
        }

        @Override
        public String visitPersonRole(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitPersonRoleSubFilter(null);
        }

        @Override
        public String visitTag(StaticSearchFacet staticSearchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitTagSubFilter(null);
        }

        @Override
        public String visitDriveFileType(StaticSearchFacet staticSearchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitDriveFileTypeSubFilter(null);
        }

        @Override
        public String visitFilterTypeSearchFacet(FilterTypeSearchFacet searchFacet) {
            return FilterTagResolver.DEFAULT_TYPE_TAG;
        }

        @Override
        public String visitProfileAttribute(ProfileAttributeSearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitProfileAttributeSubFilter(null) + searchFacet.getName();
        }

        @Override
        public String visitDriveDocumentType(SearchFacet searchFacet) {
            return GetSubFilterSolrFilterQueryTag.SUBFILTER_INSTANCE.visitDriveDocumentTypeSubFilter(null);
        }
    }

    private static enum GetSubFilterSolrFilterQueryTag implements SubFilterVisitor<String>
    {
        SUBFILTER_INSTANCE;


        @Override
        public String visitDateSubFilter(@Nullable DateSubFilter filter) {
            return "sfDate";
        }

        @Override
        public String visitStartAndEndDateSubFilter(@Nullable StartAndEndDateSubFilter filter) {
            return null;
        }

        @Override
        public String visitStartDateSubFilter(@Nullable StartDateSubFilter filter) {
            return null;
        }

        @Override
        public String visitPersonRoleSubFilter(@Nullable PersonRoleSubFilter roleSubFilter) {
            return "sfRole";
        }

        @Override
        public String visitPersonIdSubFilter(@Nullable PersonIdSubFilter personIdSubFilter) {
            return null;
        }

        @Override
        public String visitOrSubFilter(@Nullable OrSubFilter orSubFilter) {
            return null;
        }

        @Override
        public String visitEntityMemberSubFilter(@Nullable EntityMemberSubFilter entityMemberSubFilter) {
            return null;
        }

        @Override
        public String visitPublicationDate(@Nullable PublicationDateFilter publicationDateFilter) {
            return null;
        }

        @Override
        public String visitDocumentFileType(@Nullable DocumentFileTypeSubFilter subfilter) {
            return "sfFileType";
        }

        @Override
        public String visitModificationDate(@Nullable ModificationDateSubFilter subfilter) {
            return "sfModDate";
        }

        @Override
        public String visitEntityDynamicAttributeSubFilter(@Nullable EntityDynamicAttributeSubFilter subFilter) {
            return "sfEntityDynAtt" + (subFilter != null ? subFilter.getAttributeId().getId() : "");
        }

        @Override
        public String visitInheritMemberSubFilter(InheritMemberSubFilter inheritMemberSubFilter) {
            return null;
        }

        @Override
        public String visitInheritAdminSubFilter(InheritAdminSubFilter inheritAdminSubFilter) {
            return null;
        }

        @Override
        public String visitCoadminSubFilter(CoadminSubFilter coadminSubFilter) {
            return null;
        }

        @Override
        public String visitArchiveSubFilter(@Nullable ArchiveSubFilter archiveSubFilter) {
            return "sfArchive";
        }

        @Override
        public String visitBlockedSubFilter(@Nullable BlockSubFilter blockedSubFilter) {
            return "sfBlock";
        }

        @Override
        public String visitEntityStatusSubFilter(@Nullable EntityStatusSubFilter entityStatusSubFilter) {
            return "sfEntityStatus";
        }

        @Override
        public String visitTagSubFilter(@Nullable TagSubFilter tagSubFilter) {
            return "sfTag";
        }

        @Override
        public String visitDriveFileTypeSubFilter(@Nullable DriveFileTypeSubFilter driveFileTypeSubFilter) {
            return "sfDriveFileType";
        }

        @Override
        public String visitProfileAttributeSubFilter(@Nullable ProfileAttributeSubFilter subFilter) {
            return "sfProfileAttribute" + (subFilter != null ? subFilter.getName() : "");
        }

        @Override
        public String visitDriveDocumentTypeSubFilter(@Nullable DriveDocumentTypeSubFilter driveDocumentTypeSubfilter) {
            return "sfDocumentType";
        }
    }
}

