/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.appswitcher.business.AppConfigService;
import de.justsoftware.onx.appswitcher.model.AppConfig;
import de.justsoftware.onx.appswitcher.model.AppConfigChangedEvent;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.business.configfile.ConfigFileChangeEvent;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.business.FilterConfiguration;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeVisitor;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class FilterConfigurationImpl
implements ServerEventHandler,
FilterConfiguration,
InitializingBean {
    private final Settings _settings;
    private final EntityConfigService _entityConfigService;
    private final AppConfigService _appConfigService;
    private volatile Supplier<ImmutableSet<FilterType>> _orderedFilterTypes;
    private final FilterTypeVisitor.FilterTypeVisitorPredicate _onlyActiveEntityFilterTypesPredicate = new FilterTypeVisitor.FilterTypeVisitorPredicate(){

        private Boolean visitApp(CoreApp app) {
            return FilterConfigurationImpl.this._appConfigService.getAllAppConfigs().stream().map(AppConfig::getAppId).anyMatch(app.getAppId()::equals);
        }

        @Override
        public Boolean visitDefault() {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visitEntity(EntityType entityType) {
            return FilterConfigurationImpl.this._entityConfigService.getOrderedActivatedEntityTypes().contains((Object)entityType);
        }

        @Override
        public Boolean visitNewsChannels() {
            return this.visitApp(CoreApp.NEWS);
        }

        @Override
        public Boolean visitNewsPosts() {
            return this.visitApp(CoreApp.NEWS);
        }

        @Override
        public Boolean visitWiki() {
            return this.visitApp(CoreApp.WIKI);
        }

        @Override
        public Boolean visitChapter() {
            return this.visitApp(CoreApp.WIKI);
        }

        @Override
        public Boolean visitArticle() {
            return this.visitApp(CoreApp.WIKI);
        }

        @Override
        public Boolean visitChats() {
            return this.visitApp(CoreApp.CONVERSATIONS);
        }
    };

    @Autowired
    public FilterConfigurationImpl(Settings settings, EntityConfigService entityConfigService, AppConfigService appConfigService) {
        this._settings = settings;
        this._entityConfigService = entityConfigService;
        this._appConfigService = appConfigService;
        this.initCaches();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onConfigFileChanged(ConfigFileChangeEvent e) {
        this.initCaches();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAppConfigChanged(AppConfigChangedEvent e) {
        this.initCaches();
    }

    private void initCaches() {
        this._orderedFilterTypes = Suppliers.memoize(() -> {
            Iterable allActiveEntityTypes = this._entityConfigService.getOrderedActivatedEntityTypes().stream().map(FilterTypes.GET_BY_TYPE).collect(Collectors.toSet());
            return FluentIterable.from(this.getActiveFilterTypes()).append((Object[])new FilterType[]{StaticFilterType.DOCUMENTS}).append(this.getAppSpecificFilterTypes()).append(allActiveEntityTypes).toSet();
        });
    }

    @Override
    public ImmutableSet<FilterType> getOrderedFilterTypes() {
        return this._orderedFilterTypes.get();
    }

    @Nonnull
    private ImmutableSet<FilterType> getActiveFilterTypes() {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this._settings.getActiveFilterTypes(), (Predicate)this._onlyActiveEntityFilterTypesPredicate));
    }

    private ImmutableSet<FilterType> getAppSpecificFilterTypes() {
        HashMap appToFilterTypeMap = Maps.newHashMap();
        appToFilterTypeMap.put(CoreApp.NEWS.getAppId(), Set.of(StaticFilterType.NEWS_CHANNELS, StaticFilterType.NEWS_POSTS));
        appToFilterTypeMap.put(CoreApp.CONVERSATIONS.getAppId(), Set.of(StaticFilterType.CHATS));
        appToFilterTypeMap.put(CoreApp.WIKI.getAppId(), Set.of(StaticFilterType.WIKI_WIKIS, StaticFilterType.WIKI_CHAPTERS, StaticFilterType.WIKI_ARTICLES));
        appToFilterTypeMap.put(CoreApp.PEOPLE.getAppId(), Set.of(StaticFilterType.PROFILES));
        return (ImmutableSet)this._appConfigService.getAllAppConfigs().stream().map(AppConfig::getAppId).filter(appToFilterTypeMap::containsKey).map(appToFilterTypeMap::get).reduce(Set.of(), Sets::union).stream().collect(ImmutableSet.toImmutableSet());
    }

    public void afterPropertiesSet() {
        this._settings.registerActiveFilterTypesChangedListener(event -> this.initCaches());
    }
}

