/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.Actions;
import de.justsoftware.onx.common.shared.model.action.DynamicActionCreator;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.EntityDynamicAttributesUtil;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityChildrenService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityTeaserService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import de.justsoftware.onx.container.shared.model.teasers.StaticTeaser;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.searchnew.business.AdditionalData;
import de.justsoftware.onx.searchnew.business.AdditionalSuggestData;
import de.justsoftware.onx.searchnew.business.EntitySearchHandler;
import de.justsoftware.onx.searchnew.business.impl.AbstractSearchHandler;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.searchnew.shared.model.ArchiveSubFilter;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchResultModel;
import de.justsoftware.onx.searchnew.shared.model.EntitySearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.EntitySuggest;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.server.model.MultiWikiSearchFieldModel;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntitySearchHandlerImpl
extends AbstractSearchHandler<EntityId, EntityType>
implements EntitySearchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(EntitySearchHandlerImpl.class);
    @Autowired
    private EntityService _entityService;
    @Autowired
    private EntityConfigService _entityConfig;
    @Autowired
    private EntityTeaserService _entityTeaserService;
    @Autowired
    private EntityVersionService _entityVersionService;
    @Autowired
    private EntityChildrenService _entityChildrenService;

    @Override
    public ImmutableMap<CompoundId, EntitySearchResultBadgeModel> createSearchResultBadgeModel(Iterable<? extends CommonSearchResultModel> searchResultModel, boolean isNavigatorSearch, EntityType navigatorRootEntityType, SearchAuthorizationCheckContext authorizationContext) {
        if (Iterables.isEmpty(searchResultModel)) {
            return ImmutableMap.of();
        }
        AdditionalData.AdditionalEntityData additionalData = this.loadBadgeData(searchResultModel, isNavigatorSearch, navigatorRootEntityType, authorizationContext);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (CommonSearchResultModel commonSearchResultModel : searchResultModel) {
            EntitySearchResultBadgeModel badge = this.createSearchResultBadgeModel(commonSearchResultModel, additionalData, authorizationContext);
            if (badge == null) continue;
            result.put((Object)CompoundId.of((GlobalId)badge.getId()), (Object)badge);
        }
        return result.build();
    }

    @CheckForNull
    private EntitySearchResultBadgeModel createSearchResultBadgeModel(@Nonnull CommonSearchResultModel searchResultModel, @Nonnull AdditionalData.AdditionalEntityData additionalData, @Nonnull SearchAuthorizationCheckContext authorizationContext) {
        DBEntity dbBean = (DBEntity)additionalData.getDBBeans().get(CompoundId.of(searchResultModel));
        if (dbBean == null) {
            LOG.warn("No db data found for " + searchResultModel.getId() + ". Skip it!");
            return null;
        }
        EntitySearchResultBadgeModel result = new EntitySearchResultBadgeModel();
        this.initDBData(result, dbBean, additionalData);
        result.setName(searchResultModel.getNameSubstring());
        result.setModifyDate(searchResultModel.getModifyDate());
        result.setPublicationDate(searchResultModel.getPublicationDate());
        result.setExpirationDate(searchResultModel.getExpirationDate());
        if (additionalData.getMay().get((Object)Optional.of((Object)dbBean.getId())).contains((Object)StaticEntityAction.ENTITY_READ_DETAILS)) {
            String delimiter = "... ";
            this.addFoundInData(result, searchResultModel, "... ", authorizationContext);
        }
        result.setMemberWorkflow(this._entityConfig.getEntityMemberWorkflow(dbBean.getType()));
        return result;
    }

    private void initDBData(@Nonnull EntitySearchResultBadgeModel result, @Nonnull DBEntity dbBean, @Nonnull AdditionalData.AdditionalEntityData additionalEntityData) {
        EntityType entityType = dbBean.getType();
        EntityId entityId = dbBean.getId();
        result.setId(entityId);
        result.setLogo(dbBean.getLogo());
        result.setIcon(dbBean.getIcon());
        result.setType(dbBean.getType());
        result.setDescription(dbBean.getDescription());
        EntityDurationTimeOption durationTimeOption = this._entityConfig.getDurationTimeOption(entityType);
        if (durationTimeOption != EntityDurationTimeOption.OFF) {
            result.setEndAt(dbBean.getEndAt());
            result.setStartAt(dbBean.getStartAt());
            if (durationTimeOption == EntityDurationTimeOption.WITH_TIME_ZONE) {
                result.setTimeZone(dbBean.getTimeZone());
            } else {
                result.setTimeZone(null);
            }
        } else {
            result.setEndAt(null);
            result.setStartAt(null);
            result.setTimeZone(null);
        }
        if (this._entityConfig.freetextLocationActivated(entityType)) {
            result.setLocation(dbBean.getLocation());
        } else {
            result.setLocation(null);
        }
        result.setTeaserText((String)additionalEntityData.getTeaserTexts().get((Object)entityId));
        result.setLinkedEntities(EntitySearchHandlerImpl.getVisibleParents(additionalEntityData.getParentInfos(), dbBean.getLinkedEntities()));
        result.setVersion((EntityVersionClientModel)additionalEntityData.getVersions().get((Object)entityId));
        result.setLastPublicVersion((EntityVersionClientModel)additionalEntityData.getPublicVersions().get((Object)entityId));
        result.setApp(this._entityService.getAppForEntityType(entityType));
        Long childrenCount = (Long)additionalEntityData.getChildrenCountMap().get((Object)entityId);
        if (childrenCount != null) {
            result.setHasChildren(childrenCount > 0L);
        }
    }

    @Nonnull
    private static ImmutableList<EntityInfo> getVisibleParents(@Nonnull ImmutableMap<EntityId, EntityInfo> parentInfos, @Nullable List<DBEntityLink> parentLinks) {
        if (CollectionUtils.isEmpty(parentLinks)) {
            return ImmutableList.of();
        }
        Iterable result = Iterables.transform(parentLinks, (Function)Functions.compose((Function)Functions.forMap(parentInfos, null), DBEntityLink::getLinkedEntityId));
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)result, EntityInfo.IS_VISIBLE));
    }

    private void addFoundInData(@Nonnull EntitySearchResultBadgeModel searchResultBadgeModel, @Nonnull CommonSearchResultModel searchResultModel, @Nonnull String delimiter, @Nonnull SearchAuthorizationCheckContext authorizationContext) {
        String fieldName;
        Map<String, List<String>> highlightedFields = searchResultModel.getHighlightedFields();
        if (highlightedFields == null) {
            return;
        }
        EntitySearchHandlerImpl.addFoundInField("description", searchResultBadgeModel, searchResultModel, delimiter);
        EntitySearchHandlerImpl.addFoundInField("content", searchResultBadgeModel, searchResultModel, delimiter);
        EntitySearchHandlerImpl.addFoundInField("tags", searchResultBadgeModel, searchResultModel, delimiter);
        EntitySearchHandlerImpl.addFoundInField("location", searchResultBadgeModel, searchResultModel, delimiter);
        ImmutableSet<String> personRoles = authorizationContext.getStaticUserRolesForSearchQuery();
        for (String role : personRoles) {
            fieldName = MultiWikiSearchFieldModel.fieldNameFromRole(role);
            List<String> values = highlightedFields.get(fieldName);
            if (CollectionUtil.isEmpty(values)) continue;
            EntitySearchHandlerImpl.addFoundInField("Multiwiki", Joiner.on((String)", ").join(values), searchResultBadgeModel, true);
            break;
        }
        for (DynamicAttributeConfig attribConfig : this._entityConfig.getSearchableDynamicAttributes().get((Object)((EntityType)searchResultBadgeModel.getType()))) {
            fieldName = EntityDynamicAttributesUtil.toSearchFieldName(attribConfig.getId(), (EntityType)searchResultBadgeModel.getType());
            EntitySearchHandlerImpl.addFoundInField(fieldName, searchResultBadgeModel, searchResultModel, delimiter);
        }
    }

    @Nonnull
    private AdditionalData.AdditionalEntityData loadBadgeData(@Nonnull Iterable<? extends CommonSearchResultModel> searchResultList, boolean isNavigatorSearch, @Nullable EntityType navigatorRootEntityType, @Nonnull SearchAuthorizationCheckContext authCtx) {
        AdditionalSuggestData.AdditionalEntitySuggestData loadSuggestData = this.loadSuggestData(searchResultList, authCtx);
        Map entities = loadSuggestData.getDBBeans();
        if (entities.isEmpty()) {
            return AdditionalData.AdditionalEntityData.EMPTY;
        }
        ImmutableSet versionedEntities = FluentIterable.from(entities.values()).filter((Predicate)new NullIsFalsePredicate<DBEntity>(){

            @Override
            public boolean applySafe(DBEntity input) {
                return EntitySearchHandlerImpl.this._entityConfig.releaseProcessMandatory(input.getType());
            }
        }).transform(DBEntity.TO_ENTITY_ID).toSet();
        Function<EntityVersion, EntityVersionClientModel> toClientModel = new Function<EntityVersion, EntityVersionClientModel>(){

            public EntityVersionClientModel apply(EntityVersion input) {
                return new EntityVersionClientModel(input);
            }
        };
        ImmutableMap versions = ImmutableMap.copyOf((Map)Maps.transformValues(this._entityVersionService.getCurrentEntityVersions((Set<EntityId>)versionedEntities, authCtx), (Function)toClientModel));
        ImmutableMap publicVersions = ImmutableMap.copyOf((Map)Maps.transformValues(this._entityVersionService.getPublicVersions((ImmutableSet<EntityId>)versionedEntities, authCtx), (Function)toClientModel));
        ImmutableMap byTypes = Multimaps.index(entities.values(), DBEntity.TO_ENTITY_TYPE).asMap();
        ImmutableMap.Builder teaserEntities = ImmutableMap.builder();
        for (Map.Entry entry : byTypes.entrySet()) {
            if (!this._entityConfig.showDescriptionInSearchBadge((EntityType)entry.getKey())) continue;
            teaserEntities.putAll((Map)Maps.uniqueIndex((Iterable)((Iterable)entry.getValue()), DBEntity.TO_ENTITY_ID));
        }
        ImmutableMap<EntityId, String> teasers = this._entityTeaserService.getTeaserTexts(StaticTeaser.SEARCH_RESULT_WITH_TEASER_TEXT, (Map<EntityId, DBEntity>)teaserEntities.build(), authCtx);
        ImmutableMap<EntityId, EntityInfo> parentInfos = this.loadParentInfos(entities.values(), authCtx);
        Iterable entityItems = Iterables.transform(entities.values(), EntityItem.FROM_DBENTITY);
        ImmutableSetMultimap may = authCtx.may(entityItems, ImmutableSet.of((Object)StaticEntityAction.ENTITY_READ_DETAILS));
        ImmutableMap<EntityId, Long> childrenCountMap = ImmutableMap.of();
        if (isNavigatorSearch && navigatorRootEntityType != null) {
            ImmutableSet<FilterType> filterTypes = this._entityConfig.getHierarchyFilterTypes(navigatorRootEntityType);
            ImmutableList subFilter = ImmutableList.of((Object)ArchiveSubFilter.NON_ARCHIVED);
            childrenCountMap = this._entityChildrenService.getVisibleChildrenCountsMappedByEntityId(authCtx, (Set<EntityId>)FluentIterable.from(entities.values()).transform(DBEntity.TO_ENTITY_ID).toSet(), true, (Set<FilterType>)filterTypes, (Iterable<? extends SubFilter>)subFilter);
        }
        return new AdditionalData.AdditionalEntityData(loadSuggestData, teasers, parentInfos, may, (ImmutableMap<EntityId, EntityVersionClientModel>)versions, (ImmutableMap<EntityId, EntityVersionClientModel>)publicVersions, childrenCountMap);
    }

    @Nonnull
    private ImmutableMap<EntityId, EntityInfo> loadParentInfos(@Nonnull Iterable<DBEntity> entities, @Nonnull AuthorizationCheckContextWithLocale authCtx) {
        Iterable parentLinks = Iterables.concat((Iterable)Iterables.transform(entities, DBEntity.GET_LINKED_ENTITIES));
        ImmutableSet parentIds = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)parentLinks, DBEntityLink::getLinkedEntityId));
        return this._entityService.getInfoMapByIds((Set<EntityId>)parentIds, authCtx);
    }

    @Override
    protected final EntityId createId(String stringId) {
        return new EntityId(CompoundId.parseLongId(stringId));
    }

    @Override
    protected boolean canHandle(Type type) {
        return type instanceof EntityType;
    }

    @Override
    public ImmutableMap<CompoundId, EntitySuggest> createSearchResultSuggestModel(Iterable<? extends CommonSearchResultModel> searchResultModel, AuthorizationCheckContextWithUserId authorizationContext) {
        if (Iterables.isEmpty(searchResultModel)) {
            return ImmutableMap.of();
        }
        AdditionalSuggestData.AdditionalEntitySuggestData additionalData = this.loadSuggestData(searchResultModel, authorizationContext);
        ImmutableSetMultimap suggestMay = authorizationContext.may(Iterables.transform(additionalData.getDBBeans().values(), EntityItem.FROM_DBENTITY), this.getCheckActions());
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (CommonSearchResultModel commonSearchResultModel : searchResultModel) {
            EntitySuggest suggest = this.createSearchResultSuggestModel(commonSearchResultModel, additionalData, suggestMay);
            if (suggest == null) continue;
            result.put((Object)CompoundId.of((GlobalId)suggest.getId()), (Object)suggest);
        }
        return result.build();
    }

    @CheckForNull
    private EntitySuggest createSearchResultSuggestModel(@Nonnull CommonSearchResultModel searchResultModel, @Nonnull AdditionalSuggestData.AdditionalEntitySuggestData additionalEntityData, @Nonnull ImmutableSetMultimap<Optional<EntityId>, Action> suggestMay) {
        DBEntity dbEntity = (DBEntity)additionalEntityData.getDBBeans().get(CompoundId.of(searchResultModel));
        if (dbEntity == null) {
            LOG.warn("No db data found for " + searchResultModel.getId() + ". Skip it!");
            return null;
        }
        EntitySuggest suggest = new EntitySuggest();
        EntityType type = dbEntity.getType();
        this.applySearchData(searchResultModel, type, suggest);
        suggest.setName(dbEntity.getName());
        suggest.setEntityType(type);
        suggest.setLogo(dbEntity.getLogo());
        suggest.setModifyDate(dbEntity.getModifyDate());
        suggest.setStartAt(dbEntity.getStartAt());
        suggest.setEndAt(dbEntity.getEndAt());
        suggest.setTimeZone(dbEntity.getTimeZone());
        suggest.setShowLogo(this._entityConfig.logoActivated(type) || this._entityConfig.getDurationTimeOption(type) != EntityDurationTimeOption.OFF);
        suggest.setExpirationDate(searchResultModel.getExpirationDate());
        suggest.setLinkedEntities(EntitySearchHandlerImpl.getVisibleParents(additionalEntityData.getParentInfos(), dbEntity.getLinkedEntities()));
        suggest.setApp(this._entityService.getAppForEntityType(dbEntity.getType()));
        suggest.setMay((ImmutableSet<Action>)suggestMay.get((Object)Optional.of((Object)dbEntity.getId())));
        return suggest;
    }

    @Nonnull
    private ImmutableSet<Action> getCheckActions() {
        return ImmutableSet.builder().addAll(Actions.createEntityTypeBasedAction(DynamicActionCreator.ENTITY_SELECT_PARENT, this._entityConfig.getOrderedEntityTypes())).add((Object[])new Action[]{StaticEntityAction.ENTITY_MEMBER_ADD_TO_INVITEE_LIST, StaticEntityAction.ENTITY_INVITE, StaticEntityAction.ENTITY_RECOMMEND, StaticEntityAction.ENTITY_MEMBER_ADD_TO_RECOMMEND_LIST}).build();
    }

    @Nonnull
    private AdditionalSuggestData.AdditionalEntitySuggestData loadSuggestData(@Nonnull Iterable<? extends CommonSearchResultModel> searchResultList, @Nonnull AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableSet ids = ImmutableSet.copyOf((Iterable)Iterables.transform(searchResultList, (Function)this._getId));
        if (Iterables.isEmpty((Iterable)ids)) {
            return AdditionalSuggestData.AdditionalEntitySuggestData.EMPTY;
        }
        Map<EntityId, DBEntity> entities = this._entityService.getByIds((Set<EntityId>)ids);
        if (entities == null || entities.isEmpty()) {
            return AdditionalSuggestData.AdditionalEntitySuggestData.EMPTY;
        }
        HashMap loadDBBeans = Maps.newHashMap();
        for (Map.Entry<EntityId, DBEntity> entityEntry : entities.entrySet()) {
            DBEntity entity = entityEntry.getValue();
            CompoundId compoundId = new CompoundId(entity.getId().getId(), ItemType.ENTITY.name());
            loadDBBeans.put(compoundId, entity);
        }
        return new AdditionalSuggestData.AdditionalEntitySuggestData(loadDBBeans, this.loadParentInfos(entities.values(), authorizationContext));
    }
}

