/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorityUtil;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.authorization.business.PersonIndependentAuthorizationContext;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.StaticPredefinedRole;
import de.justsoftware.onx.authorization.business.StaticRole;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.EntityVersionReviewerConfig;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileReadDataService;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileAttributeSearchType;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.FilterConfiguration;
import de.justsoftware.onx.searchnew.business.SearchLtrTrackingPublisher;
import de.justsoftware.onx.searchnew.business.SearchService;
import de.justsoftware.onx.searchnew.business.criteria.Criterion;
import de.justsoftware.onx.searchnew.business.criteria.FilterQueryCriteria;
import de.justsoftware.onx.searchnew.business.criteria.LocalParam;
import de.justsoftware.onx.searchnew.business.impl.FilterTagResolver;
import de.justsoftware.onx.searchnew.business.impl.RolesSearchServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.SearchResultFacetCountsExtractor;
import de.justsoftware.onx.searchnew.business.impl.SolrRequestException;
import de.justsoftware.onx.searchnew.business.impl.SubFilterToSearchCriterionVisitor;
import de.justsoftware.onx.searchnew.business.model.JustSearchApp;
import de.justsoftware.onx.searchnew.business.model.SearchLtrFeedbackTrackingInfo;
import de.justsoftware.onx.searchnew.business.model.SearchLtrSearchResult;
import de.justsoftware.onx.searchnew.business.model.SearchLtrSearchTrackingInfo;
import de.justsoftware.onx.searchnew.shared.model.CoadminSubFilter;
import de.justsoftware.onx.searchnew.shared.model.CommonFilterTypeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchModel;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchResultModel;
import de.justsoftware.onx.searchnew.shared.model.EntityDynamicAttributeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.EntityFilterType;
import de.justsoftware.onx.searchnew.shared.model.EntityFilterTypeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.EntityMemberSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityStatusSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeCountType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeVisitor;
import de.justsoftware.onx.searchnew.shared.model.InheritAdminSubFilter;
import de.justsoftware.onx.searchnew.shared.model.InheritMemberSubFilter;
import de.justsoftware.onx.searchnew.shared.model.LearnToRankToggleValue;
import de.justsoftware.onx.searchnew.shared.model.OrSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PersonRoleSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PersonSuggest;
import de.justsoftware.onx.searchnew.shared.model.ProfileAttributeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchContextFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchContextModel;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import de.justsoftware.onx.searchnew.shared.model.SearchTrackingAction;
import de.justsoftware.onx.searchnew.shared.model.SimpleSearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.SuggestModel;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.onx.zookeeper.LTRSearchConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractSearchService
implements SearchService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSearchService.class);
    @Autowired
    protected EntityService _entityService;
    @Autowired
    protected FilterConfiguration _filterConfiguration;
    @Autowired
    protected EntityConfigService _entityConfigService;
    @Autowired
    protected SearchConfigurationProvider _searchConfigurationProvider;
    @Autowired
    protected Settings _settings;
    @Value(value="${SOLR.useSoftCommit}")
    protected boolean _useSoftCommit;
    @Autowired
    @Qualifier(value="writeSolrServer")
    protected SolrClient _writeSolrServer;
    @Autowired
    protected LTRSearchConfiguration _ltrSearchConfiguration;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private ProfileReadDataService _profileReadDataService;
    @Autowired
    @Qualifier(value="readSolrServer")
    private SolrClient _readSolrServer;
    @Autowired
    private AuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private SearchLtrTrackingPublisher _searchLtrTrackingPublisher;
    @Autowired
    private PersonRoleService _personRoleService;
    private final FilterTypeVisitor.FilterTypeVisitorFunction<ImmutableSet<? extends SearchFacet>> _filterTypeToSearchFacetVisitor = new FilterTypeVisitor.FilterTypeVisitorFunction<ImmutableSet<? extends SearchFacet>>(){

        @Override
        public ImmutableSet<? extends SearchFacet> visitDefault() {
            return ImmutableSet.of();
        }

        @Override
        public ImmutableSet<SearchFacet> visitEntity(EntityType entityType) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (DynamicAttributeConfig dynamicEntityAttributeConfig : AbstractSearchService.this._entityConfigService.getFacettableDynamicAttributesForType(entityType)) {
                result.add((Object)new EntityDynamicAttributeSearchFacet(dynamicEntityAttributeConfig.getId(), entityType));
            }
            if (AbstractSearchService.this._entityConfigService.showEntityStatusSearchFilter(entityType)) {
                result.add((Object)new EntityStatusSearchFacet(entityType));
            }
            return result.build();
        }

        @Override
        public ImmutableSet<SearchFacet> visitProfiles() {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            ImmutableCollection<ProfileAttributeConfiguration> allAttributeConfigurations = AbstractSearchService.this._profileReadDataService.getAttributesConfiguration().getAllAttributeConfigurations();
            for (ProfileAttributeConfiguration pac : allAttributeConfigurations) {
                if (!ProfileAttributeSearchType.isFacetable(pac)) continue;
                builder.add((Object)new ProfileAttributeSearchFacet(pac.getName()));
            }
            return builder.build();
        }
    };

    @Nonnull
    protected QueryResponse executePagingQuery(@Nonnull ModifiableSolrParams params, int offset, int numberOfResults) {
        params.set("start", offset);
        params.set("rows", numberOfResults);
        return this.executeQuery(params);
    }

    @Nonnull
    protected QueryResponse executeQuery(@Nonnull ModifiableSolrParams params) {
        try {
            QueryResponse result = this._readSolrServer.query((SolrParams)params, SolrRequest.METHOD.POST);
            if (result != null) {
                return result;
            }
        }
        catch (IOException | SolrServerException e) {
            LOG.error("Error occured while executing query " + params.toString(), e);
        }
        catch (SolrException e) {
            LOG.error("Error occured while executing query " + params.toString(), (Throwable)e);
            throw e;
        }
        return this.createEmptyQueryResponse();
    }

    @Nonnull
    protected QueryResponse createEmptyQueryResponse() {
        return new QueryResponse();
    }

    @Nonnull
    protected ImmutableMap<FilterType, ImmutableMultiset<FilterTypeCountType>> getFilterCount(@Nonnull ImmutableMap<SearchFacet, SearchFacetCounts> facetCounts) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry facetCount : facetCounts.entrySet()) {
            SearchFacet searchFacet = (SearchFacet)facetCount.getKey();
            FilterType filterType = this.getFilterType(searchFacet);
            if (filterType == null) continue;
            FilterTypeCountType countType = this.getFacetCountType(searchFacet);
            int count = this.getCount((SearchFacetCounts)facetCount.getValue(), searchFacet.getFacetName());
            result.computeIfAbsent(filterType, ft -> ImmutableMultiset.builder()).setCount((Object)countType, count);
        }
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)result, ImmutableMultiset.Builder::build));
    }

    @CheckForNull
    private FilterType getFilterType(@Nonnull SearchFacet searchFacet) {
        return FilterTypeSearchFacet.class.isInstance(searchFacet) ? ((FilterTypeSearchFacet)FilterTypeSearchFacet.class.cast(searchFacet)).getFilterType() : null;
    }

    @Nonnull
    private FilterTypeCountType getFacetCountType(@Nonnull SearchFacet searchFacet) {
        return EntityFilterTypeSearchFacet.class.isInstance(searchFacet) ? ((EntityFilterTypeSearchFacet)EntityFilterTypeSearchFacet.class.cast(searchFacet)).getCountType() : FilterTypeCountType.STANDARD;
    }

    @ParametersAreNonnullByDefault
    private int getCount(SearchFacetCounts facetCounts, String facetName) {
        return facetCounts instanceof SimpleSearchFacetCounts ? Numbers.intValue(((SimpleSearchFacetCounts)SimpleSearchFacetCounts.class.cast(facetCounts)).getFacetCount(facetName), 0) : 0;
    }

    @Override
    public void deleteAllDocumentsForSearchApp(JustSearchApp app) {
        try {
            this._writeSolrServer.deleteByQuery(String.format("%s:%s", new Object[]{"just_app_id", app}));
            LOG.debug("Successfully deleted solr documents for app " + app);
        }
        catch (IOException | SolrServerException e) {
            LOG.error("Error occured during deleting solr documents for app " + app);
            throw new ServiceException(e);
        }
    }

    @Override
    public void deleteFromSearchIndex(Set<FilterType> filterTypes) {
        try {
            this.delete(filterTypes);
        }
        catch (SolrRequestException e) {
            LOG.error("Error during full-import of data", (Throwable)e);
            throw new ServiceException("Error during full-import of data", e);
        }
    }

    protected boolean updateBeans(SolrClient solrServer, List<CommonSearchModel> searchModels) throws SolrRequestException {
        try {
            solrServer.addBeans(searchModels);
            return true;
        }
        catch (IOException | RuntimeException | SolrServerException e) {
            LOG.error("Error occured during updating searchModels", e);
            throw new SolrRequestException(e);
        }
    }

    protected boolean delete(@Nonnull Iterable<FilterType> filterTypes) throws SolrRequestException {
        try {
            for (FilterType type : filterTypes) {
                this._writeSolrServer.deleteByQuery(String.format("(%s:%s AND %s:%s)", new Object[]{"type", type.getType().name(), "just_app_id", JustSearchApp.CONNECT}));
            }
            this._writeSolrServer.commit();
            LOG.debug("Successfully deleted solr documents of types " + filterTypes);
            return true;
        }
        catch (SolrServerException e) {
            LOG.error("Error occured during deleting solr documents of types " + filterTypes);
            throw new SolrRequestException(e);
        }
        catch (IOException e) {
            LOG.error("Error occured during deleting solr documents of types " + filterTypes, (Throwable)e);
            throw new SolrRequestException(e);
        }
    }

    @Nonnull
    protected SearchResult<CommonSearchResultModel> toSearchResult(@Nullable QueryResponse response, boolean highlight, @Nonnull ImmutableSet<SearchFacet> searchFacets, @Nullable Iterable<? extends SubFilter> additionalFilter, @Nonnull Optional<String> highlightingFacetString, @Nonnull SearchAuthorizationCheckContext authorizationCheckContext) {
        if (response == null || response.getResults() == null) {
            return SearchResult.empty();
        }
        ImmutableList result = CollectionUtil.nonNullImmutableList(response.getBeans(CommonSearchResultModel.class));
        if (highlight) {
            this.addHighlighting(response, (Collection<CommonSearchResultModel>)result);
        }
        int numFound = (int)response.getResults().getNumFound();
        ImmutableMap<SearchFacet, SearchFacetCounts> facetCounts = this.extractFacets(response, searchFacets, additionalFilter, highlightingFacetString, authorizationCheckContext);
        ImmutableMap<FilterType, ImmutableMultiset<FilterTypeCountType>> filterCount = this.getFilterCount(facetCounts);
        return new SearchResult<CommonSearchResultModel>(numFound, result, filterCount, facetCounts);
    }

    protected ImmutableMap<SearchFacet, SearchFacetCounts> extractFacets(@Nonnull QueryResponse response, @Nonnull ImmutableSet<SearchFacet> searchFacets, @Nullable Iterable<? extends SubFilter> additionalFilter, @Nonnull Optional<String> highlightingFacetString, final @Nonnull SearchAuthorizationCheckContext authCtx) {
        SearchResultFacetCountsExtractor.FacetDataAccessor facetDataAccessor = new SearchResultFacetCountsExtractor.FacetDataAccessor(){

            @Override
            public ImmutableMap<PersonId, PersonTeaserModel> getPersonTeaserByIds(Set<PersonId> personIds) {
                return AbstractSearchService.this._profileTeaserService.getPersonTeaserForUserWithFullNames(personIds, authCtx);
            }

            @Override
            public ImmutableSet<EntityStatus> getEntityStatus(EntityType entityType) {
                return AbstractSearchService.this._entityConfigService.getAvailableEntityStatus(entityType);
            }

            @Override
            public Optional<DynamicAttributeConfig> getEntityDynamicAttributeConfig(EntityType entityType, DynamicAttributeId entityAttributeId) {
                return FluentIterable.from(AbstractSearchService.this._entityConfigService.getFacettableDynamicAttributesForType(entityType)).firstMatch(Identifiables.idEquals(entityAttributeId));
            }
        };
        return SearchResultFacetCountsExtractor.getFacetCounts(response, searchFacets, additionalFilter, highlightingFacetString, facetDataAccessor);
    }

    @Nonnull
    protected abstract SearchResult<CommonSearchResultModel> jucoSearch(@Nullable String var1, @Nonnull Set<? extends FilterType> var2, @Nullable SortType var3, @Nullable SearchContextModel var4, @Nullable Iterable<? extends SubFilter> var5, @Nonnull SearchFacetParameters var6, int var7, int var8, @Nonnull SearchAuthorizationCheckContext var9, boolean var10, @Nullable EntityType var11, @Nonnull LTRParams var12);

    private void addHighlighting(@Nonnull QueryResponse response, Collection<CommonSearchResultModel> documents) {
        Map highlightedDocuments = response.getHighlighting();
        if (highlightedDocuments == null) {
            return;
        }
        for (CommonSearchResultModel document : documents) {
            Map highlightedFields = (Map)highlightedDocuments.get(document.getId());
            if (highlightedFields == null) continue;
            document.setHighlightedFields(highlightedFields);
            List nameSubstring = (List)highlightedFields.get(CommonSearchFields.NAME_SUBSTRING.getFieldName());
            if (CollectionUtil.isEmpty(nameSubstring)) continue;
            document.setNameSubstring((String)nameSubstring.get(0));
        }
    }

    @Override
    public SearchResult<FederatedSearchResultEntry> search(SearchParameters searchParameters, int offset, int numberOfResults, String searchTrackingId, SearchAuthorizationCheckContext authorizationContext) {
        LTRParams ltrParams = this.createLTRParams(searchParameters.getSortType(), searchTrackingId, authorizationContext);
        SearchResult<CommonSearchResultModel> searchResult = this.jucoSearch(searchParameters.getText(), (Set<? extends FilterType>)ImmutableSet.of((Object)searchParameters.getFilterTypeOrAll()), searchParameters.getSortType(), searchParameters.getSearchContextModel(), (Iterable<? extends SubFilter>)searchParameters.getSubfilter(), searchParameters.getSearchFacets(), offset, numberOfResults, authorizationContext, searchParameters.isNavigatorSearch(), searchParameters.getNavigatorRootEntityType(), ltrParams);
        if (ltrParams.isExtractLTRFeatures()) {
            this.trackSearchLtr(searchParameters, offset, searchTrackingId, searchResult, authorizationContext.getUserId());
        }
        try {
            return this.convertFederated(searchResult, searchParameters.getSearchContextModel(), searchParameters.isNavigatorSearch(), searchParameters.getNavigatorRootEntityType(), authorizationContext);
        }
        catch (RuntimeException re) {
            LOG.error("error:", (Throwable)re);
            throw re;
        }
    }

    @Nonnull
    private LTRParams createLTRParams(@Nullable SortType sortType, @Nullable String searchTrackingId, @Nonnull SearchAuthorizationCheckContext authorizationContext) {
        String featureStoreName = this._ltrSearchConfiguration.getJustSearchUpcomingFeatureStoreName();
        boolean extractLTRFeatures = this._settings.getLearnToRankEnabled() != LearnToRankToggleValue.DISABLED && searchTrackingId != null && sortType == SortType.RELEVANCE && featureStoreName != null;
        boolean useLTRReRank = this._settings.getLearnToRankEnabled() == LearnToRankToggleValue.ENABLED && sortType == SortType.RELEVANCE && authorizationContext.may(StaticAction.SEARCH_USE_LTR);
        return new LTRParams(featureStoreName, extractLTRFeatures, useLTRReRank);
    }

    private void trackSearchLtr(@Nonnull SearchParameters searchParameters, int offset, @Nullable String searchTrackingId, @Nonnull SearchResult<CommonSearchResultModel> searchResult, @Nullable PersonId personId) {
        try {
            if (searchResult.getNumberOfResults() == 0 || searchTrackingId == null || personId == null) {
                return;
            }
            List<SearchLtrSearchResult> searchResults = searchResult.getResults().stream().map(r -> new SearchLtrSearchResult(r.getId(), AbstractSearchService.extractLTRFeatures(r.getLtrFeatures()))).collect(Collectors.toList());
            ImmutableSet<PersonRole> roles = this._personRoleService.getPersonRoles(personId);
            SearchLtrSearchTrackingInfo trackingInfo = new SearchLtrSearchTrackingInfo(new DateTime(), searchTrackingId, searchParameters, searchResult.getNumberOfResults(), offset, (Set<PersonRole>)roles, searchResults);
            this._searchLtrTrackingPublisher.trackSearch(trackingInfo);
        }
        catch (RuntimeException e) {
            LOG.error("Error while tracking a search request", (Throwable)e);
        }
    }

    @Nonnull
    private static ImmutableMap<String, Double> extractLTRFeatures(@Nullable String solrLtrFeatures) throws ServiceException {
        String[] nameAndValuePairs;
        if (Strings.isNullOrEmpty((String)solrLtrFeatures)) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String nameAndValueString : nameAndValuePairs = solrLtrFeatures.split(",")) {
            String[] nameAndValue = nameAndValueString.split("=");
            if (nameAndValue.length != 2) {
                throw new ServiceException("solrLTRFeatures string invalid: " + solrLtrFeatures);
            }
            builder.put((Object)nameAndValue[0], (Object)Double.valueOf(nameAndValue[1]));
        }
        return builder.build();
    }

    @Override
    public SearchProvider getSearchProvider() {
        return SearchProvider.JUCO_PROVIDER;
    }

    @Override
    public SearchResult<FederatedSearchResultEntry> search(String searchString, Set<? extends FilterType> filterTypes, SortType sortType, SearchContextModel searchContext, Iterable<? extends SubFilter> additionalFilter, SearchFacetParameters searchFacets, int offset, int numberOfResults, SearchAuthorizationCheckContext authorizationContext) {
        LTRParams ltrParams = this.createLTRParams(sortType, null, authorizationContext);
        SearchResult<CommonSearchResultModel> searchResult = this.jucoSearch(searchString, filterTypes, sortType, searchContext, additionalFilter, searchFacets, offset, numberOfResults, authorizationContext, false, null, ltrParams);
        return this.convert(searchResult, searchContext, false, null, authorizationContext);
    }

    @Nonnull
    protected abstract SearchResult<FederatedSearchResultEntry> convertFederated(@Nonnull SearchResult<CommonSearchResultModel> var1, @Nullable SearchContextModel var2, boolean var3, @Nullable EntityType var4, @Nonnull SearchAuthorizationCheckContext var5);

    @Nonnull
    protected abstract SearchResult<FederatedSearchResultEntry> convert(@Nonnull SearchResult<CommonSearchResultModel> var1, @Nullable SearchContextModel var2, boolean var3, EntityType var4, @Nonnull SearchAuthorizationCheckContext var5);

    protected String concat(Collection<String> elements, String delimiter) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        Iterator<String> iterator = elements.iterator();
        while (iterator.hasNext()) {
            String element = iterator.next();
            result.append(element);
            if (!iterator.hasNext()) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    @Override
    public SearchResult<SuggestModel<?, ?>> suggest(String searchString, SearchContextModel searchContext, ImmutableSet<? extends FilterType> filterTypes, SortType sortType, Collection<SubFilter> additionalFilter, int offset, int numberOfResults, SearchAuthorizationCheckContext authorizationContext) {
        boolean useLTRReRank = this._settings.getLearnToRankEnabled() == LearnToRankToggleValue.ENABLED && sortType == SortType.RELEVANCE && authorizationContext.may(StaticAction.SUGGEST_USE_LTR);
        QueryResponse response = this.querySuggestedElements(searchString, searchContext, filterTypes, sortType, additionalFilter, offset, numberOfResults, useLTRReRank, authorizationContext);
        return this.convertToSuggestModelSearchResult(response, authorizationContext);
    }

    @Nonnull
    protected SearchResult<SuggestModel<?, ?>> convertToSuggestModelSearchResult(@Nullable QueryResponse response, @Nonnull SearchAuthorizationCheckContext authorizationContext) {
        if (response == null) {
            return SearchResult.empty();
        }
        SolrDocumentList results = response.getResults();
        if (results == null) {
            return SearchResult.empty();
        }
        List commonSearchResultModels = response.getBeans(CommonSearchResultModel.class);
        this.addHighlighting(response, commonSearchResultModels);
        ImmutableList<SuggestModel<?, ?>> suggestResults = this.getSuggestModels(commonSearchResultModels, authorizationContext);
        return new SearchResult((int)results.getNumFound(), suggestResults);
    }

    @Override
    public ListAndCount<PersonSuggest> getPotentialReviewersForEntityByReviewStage(EntityId entityId, int reviewStage, int offset, int numberOfResults, SearchAuthorizationCheckContext authorizationContext) {
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        EntityVersionReviewerConfig reviewerConfig = this._entityConfigService.getVersionReleaseReviewerConfig(entity.getType());
        SubFilter reviewerOrFilter = reviewerConfig.hasPredefinedReviewerRolesForStage(reviewStage) ? this.getSubFilterForReviewStageRoles(entityId, reviewStage) : this.getSubFilterForStaticEntityAction(entityId, StaticEntityAction.ENTITY_BECOME_VERSION_REVIEWER);
        return this.getPotentialMatchesBySubFilter(reviewerOrFilter, offset, numberOfResults, authorizationContext);
    }

    @Override
    public ListAndCount<PersonSuggest> getPotentialAuthorsForEntity(EntityId entityId, int offset, int numberOfResults, SearchAuthorizationCheckContext authorizationContext) {
        SubFilter orFilter = this.getSubFilterForStaticEntityAction(entityId, StaticEntityAction.ENTITY_BECOME_VERSION_AUTHOR);
        return this.getPotentialMatchesBySubFilter(orFilter, offset, numberOfResults, authorizationContext);
    }

    @Nonnull
    private ListAndCount<PersonSuggest> getPotentialMatchesBySubFilter(@Nullable SubFilter orSubFilter, int offset, int numberOfResults, @Nonnull SearchAuthorizationCheckContext authorizationContext) {
        ArrayList additionalFilter = orSubFilter != null ? Lists.newArrayList((Object[])new SubFilter[]{orSubFilter}) : null;
        SearchResult<CommonSearchResultModel> searchResult = this.jucoSearch(null, (Set<? extends FilterType>)ImmutableSet.of((Object)StaticFilterType.PROFILES), SortType.ALPHABETICAL, null, additionalFilter, StaticSearchFacetParameters.NO_FACETS, offset, numberOfResults, authorizationContext, false, null, LTRParams.ltrDisabled());
        ImmutableList<SuggestModel<?, ?>> suggestModels = this.getSuggestModels((Collection<CommonSearchResultModel>)searchResult.getResults(), authorizationContext);
        ImmutableList suggestions = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Lists.transform(suggestModels, SuggestModel.PERSON_SUGGEST), (Predicate)Predicates.notNull()));
        return new ListAndCount<PersonSuggest>(searchResult.getNumberOfResults(), SuggestModel.SUGGEST_NAME_ORDERING.sortedCopy((Iterable)suggestions));
    }

    @Override
    public SubFilter getSubFilterForStaticEntityAction(EntityId entityId, Action staticAction) {
        ImmutableSet<Role> staticRoles;
        ImmutableSet actions = ImmutableSet.of((Object)staticAction);
        PersonIndependentAuthorizationContext authorizationContext = this._authorizationContextProvider.getPersonIndependentAuthorizationContext();
        ImmutableSetMultimap neededRoles = (ImmutableSetMultimap)MoreObjects.firstNonNull((Object)((ImmutableSetMultimap)authorizationContext.neededRolesForActions((SetMultimap<? extends ItemId, ? extends Action>)ImmutableSetMultimap.of((Object)entityId, (Object)staticAction)).get((Object)entityId)), (Object)ImmutableSetMultimap.of());
        ImmutableSet.Builder roleSet = ImmutableSet.builder();
        roleSet.addAll((Iterable)neededRoles.values());
        Set<SubFilter> subFilter = this.getSubFilterForRoles(entityId, (ImmutableSet<Role>)roleSet.build());
        if (!neededRoles.containsValue((Object)StaticPredefinedRole.LOGGED_IN) && !(staticRoles = RolesSearchServiceImpl.getStaticRoles((Multimap<Action, ? extends Role>)neededRoles, (Iterable<? extends Action>)actions)).isEmpty()) {
            subFilter.add(new PersonRoleSubFilter(AuthorityUtil.names(staticRoles)));
        }
        if (!subFilter.isEmpty()) {
            return subFilter.size() > 1 ? new OrSubFilter(subFilter) : (SubFilter)subFilter.stream().findFirst().get();
        }
        return null;
    }

    @Nonnull
    private Set<SubFilter> getSubFilterForRoles(@Nonnull EntityId entityId, @Nonnull ImmutableSet<Role> neededRoles) {
        HashSet subFilter = Sets.newHashSet();
        if (!neededRoles.contains((Object)StaticPredefinedRole.LOGGED_IN)) {
            if (neededRoles.contains((Object)StaticPredefinedRole.ENTITY_MEMBER)) {
                subFilter.add(new EntityMemberSubFilter((Set<EntityId>)ImmutableSet.of((Object)entityId)));
            }
            if (neededRoles.contains((Object)StaticPredefinedRole.ENTITY_MEMBER_OF_PARENT)) {
                subFilter.add(new InheritMemberSubFilter(entityId));
            }
            if (neededRoles.contains((Object)StaticPredefinedRole.ENTITY_ADMIN_OF_PARENT)) {
                subFilter.add(new InheritAdminSubFilter(entityId));
            }
            if (neededRoles.contains((Object)StaticPredefinedRole.CO_ADMIN) || neededRoles.contains((Object)StaticPredefinedRole.ENTITY_CO_ADMIN)) {
                subFilter.add(new CoadminSubFilter(entityId));
            }
        }
        return subFilter;
    }

    @Override
    public SubFilter getSubFilterForReviewStageRoles(EntityId entityId, int stageIndex) {
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        EntityVersionReviewerConfig reviewerConfig = this._entityConfigService.getVersionReleaseReviewerConfig(entity.getType());
        ImmutableSet rolesForStage = (ImmutableSet)reviewerConfig.getReviewers().get(stageIndex);
        Set<SubFilter> subFilter = this.getSubFilterForRoles(entityId, (ImmutableSet<Role>)rolesForStage);
        Iterable filteredRoles = Iterables.filter((Iterable)rolesForStage, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(StaticRole.class)));
        if (!Iterables.isEmpty((Iterable)filteredRoles)) {
            subFilter.add(new PersonRoleSubFilter(AuthorityUtil.names(filteredRoles)));
        }
        return !subFilter.isEmpty() ? new OrSubFilter(subFilter) : null;
    }

    @Nonnull
    protected abstract QueryResponse querySuggestedElements(@Nullable String var1, @Nullable SearchContextModel var2, @Nonnull ImmutableSet<? extends FilterType> var3, @Nullable SortType var4, @Nullable Collection<SubFilter> var5, int var6, int var7, boolean var8, @Nonnull SearchAuthorizationCheckContext var9);

    @Nonnull
    protected abstract ImmutableList<SuggestModel<?, ?>> getSuggestModels(Collection<CommonSearchResultModel> var1, AuthorizationCheckContextWithUserId var2);

    protected void appendSubFilterQuery(@Nonnull SolrQuery query, @Nullable Iterable<? extends SubFilter> subfilterList) {
        if (subfilterList == null || !subfilterList.iterator().hasNext()) {
            return;
        }
        SubFilterToSearchCriterionVisitor subfilterToSearchCriterionVisitor = new SubFilterToSearchCriterionVisitor(this._entityConfigService.getSearchableDynamicAttributes());
        for (SubFilter subFilter : subfilterList) {
            Criterion filter = subFilter.accept(subfilterToSearchCriterionVisitor);
            if (filter == null) continue;
            FilterQueryCriteria filterQueryCriteria = new FilterQueryCriteria(filter);
            ImmutableList<String> tags = FilterTagResolver.INSTANCE.getSubFilterTags(subFilter);
            if (!CollectionUtil.isEmpty(tags)) {
                filterQueryCriteria.addLocalParam(new LocalParam("tag", tags));
            }
            query.addFilterQuery(new String[]{filterQueryCriteria.toSolrQuery()});
        }
    }

    @Nonnull
    protected Set<? extends FilterType> getAvailableFilterTypes(@Nonnull Set<? extends FilterType> filterTypes, boolean isNavigatorSearch, @Nullable EntityType navigatorRootEntityType) {
        Set<? extends FilterType> allowedFilterTypes = this.getAllowedFilterTypes(isNavigatorSearch, navigatorRootEntityType);
        if (filterTypes.contains(StaticFilterType.ALL)) {
            return Sets.filter(allowedFilterTypes, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)StaticFilterType.ALL)));
        }
        return Sets.intersection(filterTypes, allowedFilterTypes);
    }

    @Override
    public Set<? extends FilterType> getAllowedFilterTypes(boolean isNavigatorSearch, @Nullable EntityType navigatorRootEntityType) {
        Sets.SetView allowedFilterTypes = this._filterConfiguration.getOrderedFilterTypes();
        if (isNavigatorSearch && navigatorRootEntityType != null) {
            ImmutableSet<FilterType> hierarchyFilterTypes = this._entityConfigService.getHierarchyFilterTypes(navigatorRootEntityType);
            allowedFilterTypes = Sets.intersection(allowedFilterTypes, hierarchyFilterTypes);
        }
        return allowedFilterTypes;
    }

    @Nonnull
    protected ImmutableSet<SearchFacet> getSearchFacetsForFilter(@Nonnull Set<? extends FilterType> selectedFilter, @Nonnull SearchConfigurationProvider searchConfigurationProvider) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (SearchFacet facet : Iterables.concat(Arrays.asList(StaticSearchFacet.values()), this.getDynamicSearchFacets(selectedFilter))) {
            boolean applyForSelectedFilterType = selectedFilter.isEmpty() || selectedFilter.contains(StaticFilterType.ALL) ? facet.applyWithoutFilterType(searchConfigurationProvider) : Iterables.any(selectedFilter, facet.applyForFilterType(searchConfigurationProvider));
            if (!applyForSelectedFilterType) continue;
            builder.add((Object)facet);
        }
        return builder.build();
    }

    @CheckForNull
    private static PersonId getContextPersonId(@Nullable SearchContextModel context, @Nullable PersonId currentUserId) {
        ProfileId profileId = context != null ? context.getContextProfileId() : null;
        return profileId != null ? profileId.asPersonId() : currentUserId;
    }

    @Nonnull
    protected static ImmutableSet<SearchFacet> getSearchContextSearchFacets(@Nullable SearchContextModel selectedSearchContext, @Nullable PersonId currentUserId) {
        EntityId entityId = selectedSearchContext != null ? selectedSearchContext.getContextEntityId() : null;
        PersonId contextPersonId = AbstractSearchService.getContextPersonId(selectedSearchContext, currentUserId);
        return FluentIterable.from(Arrays.asList(SearchContext.values())).transform(SearchContextFacet.forContextFunction(entityId, contextPersonId)).filter(Predicates.notNull()).toSet();
    }

    @Nonnull
    protected ImmutableSet<SearchFacet> getFilterTypeSearchFacets(@Nonnull ImmutableSet<FilterType> availableFilterTypes, @Nullable SearchContextModel selectedSearchContext, @Nullable PersonId currentUserId) {
        PersonId contextPersonId = AbstractSearchService.getContextPersonId(selectedSearchContext, currentUserId);
        boolean isMyContext = selectedSearchContext != null && selectedSearchContext.getSelectedContext().isMyContentContext();
        return this.toSearchFacets((Set<FilterType>)availableFilterTypes, isMyContext ? contextPersonId : null);
    }

    @Nonnull
    protected ImmutableSet<SearchFacet> getDynamicSearchFacets(@Nonnull Set<? extends FilterType> selectedFilter) {
        return FluentIterable.from(selectedFilter).transformAndConcat(this._filterTypeToSearchFacetVisitor).toSet();
    }

    @Nonnull
    protected ImmutableSet<SearchFacet> toSearchFacets(@Nonnull Set<FilterType> filterTypes, final @Nullable PersonId restrictedMyContextUser) {
        return FluentIterable.from(filterTypes).transformAndConcat((Function)new NullPermeableFunction<FilterType, Iterable<SearchFacet>>(){

            @Override
            protected Iterable<SearchFacet> applySafe(FilterType input) {
                if (input instanceof EntityFilterType) {
                    EntityFilterType filterType = (EntityFilterType)input;
                    EntityType entityType = filterType.getType();
                    EntityDurationTimeOption edto = AbstractSearchService.this._entityConfigService.getDurationTimeOption(entityType);
                    if (EntityDurationTimeOption.OFF.equals((Object)edto)) {
                        return ImmutableList.of((Object)new EntityFilterTypeSearchFacet(filterType, restrictedMyContextUser));
                    }
                    return ImmutableList.of((Object)new EntityFilterTypeSearchFacet(filterType, restrictedMyContextUser, FilterTypeCountType.PAST), (Object)new EntityFilterTypeSearchFacet(filterType, restrictedMyContextUser, FilterTypeCountType.FUTURE));
                }
                return ImmutableList.of((Object)new CommonFilterTypeSearchFacet(input, restrictedMyContextUser));
            }
        }).filter(Predicates.notNull()).toSet();
    }

    @Override
    public void trackFeedback(String searchTrackingId, String searchResultId, SearchTrackingAction action, SortType sortType, SearchAuthorizationCheckContext authContext) {
        if (authContext.getUserId() == null || sortType != SortType.RELEVANCE) {
            return;
        }
        if (action == SearchTrackingAction.USER_PERFORM_SEARCH) {
            LOG.warn("Ignoring search feedback tracking info for action " + SearchTrackingAction.USER_PERFORM_SEARCH);
            return;
        }
        this._searchLtrTrackingPublisher.trackFeedback(new SearchLtrFeedbackTrackingInfo(new DateTime(), searchTrackingId, searchResultId, action));
    }

    @Override
    public void optimizeIndex() {
        try {
            LOG.info("triggering index optimization");
            this._writeSolrServer.optimize(false, false);
        }
        catch (IOException | SolrServerException e) {
            LOG.error("error when trying to optimize solr index", e);
        }
    }

    protected static final class LTRParams {
        private final String _featureStoreName;
        private final boolean _extractLTRFeatures;
        private final boolean _useLTRReRank;

        public LTRParams(@Nullable String featureStoreName, boolean extractLTRFeatures, boolean useLTRReRank) {
            this._featureStoreName = featureStoreName;
            this._extractLTRFeatures = extractLTRFeatures;
            this._useLTRReRank = useLTRReRank;
        }

        @CheckForNull
        public String getFeatureStoreName() {
            return this._featureStoreName;
        }

        public boolean isExtractLTRFeatures() {
            return this._extractLTRFeatures;
        }

        public boolean isUseLTRReRank() {
            return this._useLTRReRank;
        }

        @Nonnull
        public static LTRParams ltrDisabled() {
            return new LTRParams(null, false, false);
        }
    }
}

