/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.shared.model.BadgeField;
import de.justsoftware.onx.common.shared.model.BadgeFieldType;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchResultModel;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.SearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.SuggestModel;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSearchHandler<I extends SearchableId, TY extends Type> {
    protected final Function<CommonSearchResultModel, I> _getId = new Function<CommonSearchResultModel, I>(){

        public I apply(CommonSearchResultModel input) {
            return AbstractSearchHandler.this.createId(input);
        }
    };

    protected I createId(CommonSearchResultModel searchResultModel) {
        return this.createId(searchResultModel.getId());
    }

    protected abstract I createId(String var1);

    protected static void addFoundInField(@Nonnull String fieldName, @Nonnull SearchResultBadgeModel<?, ?> badge, CommonSearchResultModel searchResult, @Nonnull String delimiter) {
        Map<String, List<String>> highlightedFields = searchResult.getHighlightedFields();
        if (highlightedFields == null) {
            return;
        }
        List<String> list = highlightedFields.get(fieldName);
        AbstractSearchHandler.addFoundInField(fieldName, list == null ? "" : Joiner.on((String)delimiter).join(list), badge, AbstractSearchHandler.isHighlighted(fieldName, searchResult.getHighlightedFields()));
    }

    protected static void addFoundInField(@Nonnull String fieldName, @Nullable String fieldContent, @Nonnull SearchResultBadgeModel<?, ?> badge, boolean isHighlighted) {
        if (StringUtils.isEmpty((String)fieldContent)) {
            return;
        }
        if (isHighlighted) {
            badge.addFoundInField(new BadgeField(fieldName, BadgeFieldType.VALUES, (ImmutableList<String>)ImmutableList.of((Object)fieldContent)));
        }
    }

    protected static boolean isHighlighted(String fieldName, Map<String, List<String>> highlightedFields) {
        if (highlightedFields == null || highlightedFields.isEmpty()) {
            return false;
        }
        return highlightedFields.keySet().contains(fieldName);
    }

    protected abstract boolean canHandle(@Nonnull Type var1);

    protected boolean canHandle(@Nullable String type) {
        FilterType filterTypes = FilterTypes.getByTypeName(type);
        return filterTypes != null && this.canHandle(filterTypes.getType());
    }

    protected void applySearchData(@Nonnull CommonSearchResultModel searchResultModel, @Nonnull TY type, @Nonnull SuggestModel<I, TY> suggestModel) {
        suggestModel.setType(type);
        suggestModel.setFileTypeId(searchResultModel.getFileTypeId());
        suggestModel.setId(this.createId(searchResultModel));
        suggestModel.setName(searchResultModel.getName());
        suggestModel.setCompoundId(searchResultModel.getId());
        suggestModel.setHtmlHighlightedName(AbstractSearchHandler.getHighlightedName(searchResultModel));
    }

    @Nonnull
    private static String getHighlightedName(@Nonnull CommonSearchResultModel searchResult) {
        Map<String, List<String>> highlightedFields = searchResult.getHighlightedFields();
        if (highlightedFields == null) {
            return (String)MoreObjects.firstNonNull((Object)searchResult.getName(), (Object)"");
        }
        List<String> nameSubstring = highlightedFields.get(CommonSearchFields.NAME_SUBSTRING.getFieldName());
        if (!CollectionUtil.isEmpty(nameSubstring)) {
            return nameSubstring.get(0);
        }
        List<String> name = highlightedFields.get(CommonSearchFields.NAME.getFieldName());
        if (!CollectionUtil.isEmpty(name)) {
            return name.get(0);
        }
        return (String)MoreObjects.firstNonNull((Object)searchResult.getName(), (Object)"");
    }
}

