/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import de.justsoftware.onx.authorization.business.AuthorityUtil;
import de.justsoftware.onx.authorization.business.StaticRole;
import de.justsoftware.onx.chat.model.ChatItem;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.server.model.AbstractSearchableItemVisitor;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.NewsChannelItem;
import de.justsoftware.onx.container.shared.server.model.NewsPostItem;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.person.shared.server.model.StartpageItem;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractRootBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.data.SearchModelVisibilities;
import de.justsoftware.onx.searchnew.business.data.SolrDataLoader;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import de.justsoftware.onx.searchnew.business.impl.RolesSearchServiceImpl;
import de.justsoftware.onx.wiki.model.ArticleItem;
import de.justsoftware.onx.wiki.model.ChapterItem;
import de.justsoftware.onx.wiki.model.WikiItem;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;
import de.justsoftware.polls.model.pollid.item.PollItem;
import javax.annotation.Nonnull;

final class VisibilitiesLoader
extends AbstractRootBasedSolrDataLoader<SearchModelVisibilities> {
    static final SolrDataLoader INSTANCE = new VisibilitiesLoader();

    private VisibilitiesLoader() {
    }

    @Override
    protected SearchModelVisibilities visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem entityItem, Item<?> item) {
        EntityId itemId = entityItem.getId();
        ImmutableMultimap neededRoles = (ImmutableMultimap)MoreObjects.firstNonNull((Object)((ImmutableSetMultimap)preloadedData._neededRolesForActions.get((Object)itemId)), (Object)ImmutableSetMultimap.of());
        ImmutableSet<StaticRole> itemDependantRoles = RolesSearchServiceImpl.getItemDependantRoles((Multimap<Action, ? extends Role>)neededRoles, SearchDataServiceImpl.ENTITY_NEEDED_ROLES_ACTIONS);
        ImmutableSet<String> staticRoles = AuthorityUtil.names(RolesSearchServiceImpl.getStaticRoles((Multimap<Action, ? extends Role>)neededRoles, SearchDataServiceImpl.ENTITY_NEEDED_ROLES_ACTIONS));
        SearchModelVisibilities visibilities = new SearchModelVisibilities();
        visibilities.setVisibilityIncludedItemDependantRoles(AuthorityUtil.names(itemDependantRoles));
        ImmutableSet<Long> visibleForPersons = preloadedData.getPersonLongIdsForItemDependantRoles(itemId, itemDependantRoles);
        visibilities.setVisibleForRoles(staticRoles);
        visibilities.setVisibleForPersons(visibleForPersons);
        return visibilities;
    }

    @Override
    protected SearchModelVisibilities visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, StartpageItem startPageItem, Item<?> item) {
        return item.accept(new ProfileComponentVisibilitiesLoaderGlobalIdVisitor(preloadedData));
    }

    @Override
    protected SearchModelVisibilities visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, ProfileItem profileItem, Item<?> item) {
        return item.accept(new ProfileComponentVisibilitiesLoaderGlobalIdVisitor(preloadedData));
    }

    @Override
    protected SearchModelVisibilities visitNonRootItem(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> nonRootItem, Item<?> item) {
        return new SearchModelVisibilities();
    }

    @Override
    protected SearchModelVisibilities visitUnsupportedRootItem(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> rootItem, Item<?> item) {
        return new SearchModelVisibilities();
    }

    @Override
    protected void set(JucoSolrInputDocument doc, SearchModelVisibilities visibilities) {
        doc.addField((SearchField)CommonSearchFields.VISIBLE_FOR_PERSONS, (Iterable<?>)visibilities.getVisibleForPersons());
        doc.addField((SearchField)CommonSearchFields.VISIBLE_FOR_ROLES, (Iterable<?>)visibilities.getVisibleForRoles());
        doc.addField((SearchField)CommonSearchFields.VISIBILITY_INCLUDED_ITEM_DEPENDANT_ROLES, (Iterable<?>)visibilities.getVisibilityIncludedItemDependantRoles());
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
    }

    private static final class ProfileComponentVisibilitiesLoaderGlobalIdVisitor
    extends AbstractSearchableItemVisitor<SearchModelVisibilities> {
        private final SearchDataServiceImpl.SearchPreloadedData _preloadedData;

        private ProfileComponentVisibilitiesLoaderGlobalIdVisitor(@Nonnull SearchDataServiceImpl.SearchPreloadedData preloadedData) {
            this._preloadedData = preloadedData;
        }

        @Override
        public SearchModelVisibilities visit(EntityItem item) {
            return new SearchModelVisibilities();
        }

        @Override
        public SearchModelVisibilities visit(ChatItem item) {
            return new SearchModelVisibilities();
        }

        @Override
        public SearchModelVisibilities visit(DriveDocumentItem driveDocumentItem) {
            return new SearchModelVisibilities();
        }

        @Override
        protected SearchModelVisibilities visitNotSearchableItem(Item<?> item) {
            return new SearchModelVisibilities();
        }

        @Override
        public SearchModelVisibilities visit(WorkstreamItem item) {
            return new SearchModelVisibilities();
        }

        @Override
        public SearchModelVisibilities visit(ProfileItem item) {
            ProfileId profileId = item.getId();
            SearchModelVisibilities result = new SearchModelVisibilities();
            ImmutableSet personVisibilities = this._preloadedData._personVisibilities.get((Object)profileId.asString());
            result.setVisibleForRoles((ImmutableSet<String>)((ImmutableSet)personVisibilities.stream().map(de.justsoftware.permission.client.model.Role::asString).collect(ImmutableSet.toImmutableSet())));
            return result;
        }

        @Override
        public SearchModelVisibilities visit(WikiItem item) {
            return new SearchModelVisibilities();
        }

        @Override
        public SearchModelVisibilities visit(ChapterItem item) {
            return new SearchModelVisibilities();
        }

        @Override
        public SearchModelVisibilities visit(ArticleItem item) {
            return new SearchModelVisibilities();
        }

        @Override
        public SearchModelVisibilities visit(PollItem pollItem) {
            return new SearchModelVisibilities();
        }

        @Override
        public SearchModelVisibilities visit(NewsPostItem newsPostItem) {
            return new SearchModelVisibilities();
        }

        @Override
        public SearchModelVisibilities visit(NewsChannelItem newsChannelItem) {
            return new SearchModelVisibilities();
        }
    }
}

