/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.comments.shared.model.db.DBComment;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.CommentVisitor;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.data.SolrDataLoader;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

final class SubscriberLoader
extends AbstractItemBasedSolrDataLoader<List<String>> {
    static final SolrDataLoader INSTANCE = new SubscriberLoader();

    private SubscriberLoader() {
    }

    @Override
    protected void set(JucoSolrInputDocument doc, List<String> value) {
        doc.addField((SearchField)CommonSearchFields.SUBSCRIBER_IDS, value);
    }

    @Override
    protected List<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem item) {
        return this.buildAuthorsSubscribersAndCommentAuthors(preloadedData, (Iterable<PersonId>)ImmutableSet.of(), item);
    }

    @Override
    protected List<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, WorkstreamItem item) {
        return this.buildAuthorsSubscribersAndCommentAuthors(preloadedData, (Iterable<PersonId>)ImmutableSet.of((Object)item.getMessage().getAuthorId().asPersonId()), item);
    }

    @Override
    protected List<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, DriveDocumentItem item) {
        return this.buildAuthorsSubscribersAndCommentAuthors(preloadedData, (Iterable<PersonId>)ImmutableSet.of(), item);
    }

    @Override
    protected boolean indexDriveAllowed() {
        return true;
    }

    @Override
    protected List<String> visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return ImmutableList.of();
    }

    @Nonnull
    private ImmutableList<String> buildAuthorsSubscribersAndCommentAuthors(@Nonnull SearchDataServiceImpl.SearchPreloadedData preloadedData, @Nonnull Iterable<PersonId> authors, @Nonnull Item<?> item) {
        Object itemId = item.getId();
        Collection<DBComment> comments = item.accept(preloadedData._commentVisitor);
        return FluentIterable.from(comments).transform(DBComment.GET_AUTHOR_ID).append(authors).append((Iterable)preloadedData._directSubscribers.get((ItemId)itemId)).filter(Predicates.notNull()).transform(CompoundId.FROM_PERSON_ID_TO_SEARCH_STRING).toSet().asList();
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
        idsCollector._directSubscribersItemIds.addAll(ids.itemIds());
        CommentVisitor.collectIds(idsCollector, ids);
    }
}

