/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.person.shared.server.model.StartpageItem;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractRootBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PathLoader
extends AbstractRootBasedSolrDataLoader<List<String>> {
    static final PathLoader INSTANCE = new PathLoader();
    static final Logger LOG = LoggerFactory.getLogger(PathLoader.class);

    private PathLoader() {
    }

    @Override
    protected void set(JucoSolrInputDocument doc, List<String> value) {
        doc.addField((SearchField)CommonSearchFields.PATH, value);
    }

    @Override
    protected List<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, StartpageItem startPageItem, Item<?> item) {
        return ImmutableList.of();
    }

    @Override
    protected List<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, ProfileItem profileItem, Item<?> item) {
        return ImmutableList.of();
    }

    @Override
    protected List<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem entityItem, Item<?> item) {
        if (!preloadedData.isIndexPath()) {
            return ImmutableList.of();
        }
        ArrayList<String> names = new ArrayList<String>((Collection)preloadedData._itemsWithPathEntityParents.get(entityItem.getId()));
        if (!(item instanceof EntityItem)) {
            names.add(entityItem.getEntity().getName());
        }
        return names;
    }

    @Override
    protected List<String> visitNonRootItem(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> nonRootItem, Item<?> item) {
        return ImmutableList.of();
    }

    @Override
    protected List<String> visitUnsupportedRootItem(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> rootItem, Item<?> item) {
        return ImmutableList.of();
    }

    @Override
    protected boolean indexDriveAllowed() {
        return true;
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
        idsCollector._itemsWithPathRootEntities.addAll(ids.rootEntities());
    }
}

