/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.Strings;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;
import org.apache.commons.lang.StringUtils;

final class NameSortLoader
extends AbstractItemBasedSolrDataLoader<String> {
    static final NameSortLoader INSTANCE = new NameSortLoader();

    private NameSortLoader() {
    }

    @Override
    protected String visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem item) {
        return item.getEntity().getName();
    }

    @Override
    protected String visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, ProfileItem item) {
        DBPerson person = item.getPerson();
        return person.getLastName() + " " + person.getFirstName();
    }

    @Override
    protected String visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, WorkstreamItem item) {
        String text = item.getMessage().getAttribute("text");
        String title = item.getMessage().getAttribute("title");
        return Strings.nullToEmpty((String)(!Strings.isNullOrEmpty((String)title) ? title : StringUtils.substring((String)text, (int)0, (int)15)));
    }

    @Override
    protected String visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return "";
    }

    @Override
    protected void set(JucoSolrInputDocument doc, String value) {
        doc.addField((SearchField)CommonSearchFields.NAME_SORT, value);
    }
}

