/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.freiheit.toro.common.shared.server.util.StringUtil;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import de.justsoftware.onx.authorization.business.AuthorityUtil;
import de.justsoftware.onx.authorization.business.StaticRole;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersionSection;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import de.justsoftware.onx.searchnew.business.impl.RolesSearchServiceImpl;
import de.justsoftware.onx.searchnew.shared.server.model.MultiWikiSearchFieldModel;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MultiWikiLoader
extends AbstractItemBasedSolrDataLoader<ImmutableSetMultimap<String, String>> {
    static final MultiWikiLoader INSTANCE = new MultiWikiLoader();
    private static final Logger LOG = LoggerFactory.getLogger(MultiWikiLoader.class);

    private MultiWikiLoader() {
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
        idsCollector._currentPublishedSectionsEntityIds.addAll(ids.entities());
    }

    @Override
    protected ImmutableSetMultimap<String, String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem item) {
        Collection currentPublishedSections = (Collection)preloadedData._currentPublishedSections.get(item.getId());
        ImmutableSetMultimap.Builder contentForRole = ImmutableSetMultimap.builder();
        for (MultiWikiVersionSection section : currentPublishedSections) {
            ImmutableMultimap neededRoles = (ImmutableMultimap)preloadedData._neededRolesForActions.get((Object)section.getId());
            ImmutableSet<StaticRole> itemDependantRoles = RolesSearchServiceImpl.getItemDependantRoles((Multimap<Action, ? extends Role>)neededRoles, SearchDataServiceImpl.MULTI_WIKI_SECTION_NEEDED_ROLES_ACTIONS);
            if (!itemDependantRoles.isEmpty()) {
                LOG.warn("Visibilities of multi wiki section must contain static roles only (parent of section: {})", (Object)section.getParentId());
            }
            ImmutableSet<String> staticRoles = AuthorityUtil.names(RolesSearchServiceImpl.getStaticRoles((Multimap<Action, ? extends Role>)neededRoles, SearchDataServiceImpl.MULTI_WIKI_SECTION_NEEDED_ROLES_ACTIONS));
            String stripHTMLSectionText = section.getHeadline() + "\n" + StringUtil.stripHTML(section.getText()) + "\n";
            for (String role : staticRoles) {
                contentForRole.put((Object)MultiWikiSearchFieldModel.fieldNameFromRole(role), (Object)stripHTMLSectionText);
            }
        }
        return contentForRole.build();
    }

    @Override
    protected ImmutableSetMultimap<String, String> visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return ImmutableSetMultimap.of();
    }

    @Override
    protected void set(JucoSolrInputDocument doc, ImmutableSetMultimap<String, String> value) {
        doc.addWildcardField((Map<String, ?>)value.asMap());
    }
}

