/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.Strings;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;

final class LocationLoader
extends AbstractItemBasedSolrDataLoader<String> {
    static final LocationLoader INSTANCE = new LocationLoader();

    private LocationLoader() {
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
    }

    @Override
    protected String visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem item) {
        DBEntity entity = item.getEntity();
        if (preloadedData.getEntityConfigService().freetextLocationActivated(entity.getType())) {
            return Strings.nullToEmpty((String)entity.getLocation());
        }
        return "";
    }

    @Override
    protected String visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return "";
    }

    @Override
    protected void set(JucoSolrInputDocument doc, String value) {
        doc.addField((SearchField)CommonSearchFields.LOCATION, value);
    }
}

