/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.Functions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class ItemsAndRootParents {
    private final FluentIterable<? extends Item<?>> _items;
    private final ImmutableMap<ItemId, Item<?>> _rootParents;

    public ItemsAndRootParents(Collection<SearchableId> allowed, Map<? extends ItemId, ? extends Item<?>> items, ImmutableMap<ItemId, Item<?>> rootParents) {
        this._items = FluentIterable.from(items.values()).filter(item -> allowed.contains(SearchableId.fromItemId((ItemId)item.getId())));
        this._rootParents = rootParents;
    }

    @Nonnull
    FluentIterable<ItemId> itemIds() {
        return this._items.transform(Item::getId);
    }

    @Nonnull
    FluentIterable<EntityId> entities() {
        return this.itemIds().filter(EntityId.class);
    }

    @Nonnull
    FluentIterable<WorkstreamMessageId> workstreamMessageIds() {
        return this.itemIds().filter(WorkstreamMessageId.class);
    }

    @Nonnull
    FluentIterable<EntityId> rootEntities() {
        return this.itemIds().transform(Functions.forMap(this._rootParents, null)).transform(Identifiables.toId()).filter(EntityId.class);
    }

    @Nonnull
    FluentIterable<PersonId> persons() {
        return this.itemIds().filter(ProfileId.class).transform(ProfileId.TO_PERSON_ID);
    }

    @Nonnull
    FluentIterable<EntityItem> entityItems() {
        return this._items.filter(EntityItem.class);
    }

    @Nonnull
    FluentIterable<WorkstreamItem> workstreamMessageItems() {
        return this._items.filter(WorkstreamItem.class);
    }

    @Nonnull
    FluentIterable<ProfileItem> profileItems() {
        return this._items.filter(ProfileItem.class);
    }
}

