/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import java.util.List;

final class InheritMembersLoader
extends AbstractItemBasedSolrDataLoader<List<String>> {
    static final InheritMembersLoader INSTANCE = new InheritMembersLoader();

    private InheritMembersLoader() {
    }

    @Override
    protected void set(JucoSolrInputDocument doc, List<String> value) {
        doc.addField((SearchField)CommonSearchFields.INHERIT_MEMBER_IDS, value);
    }

    @Override
    protected List<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem item) {
        return FluentIterable.from((Iterable)((Iterable)preloadedData._inheritedMembers.get(item.getId()))).transform(CompoundId.FROM_PERSON_ID_TO_SEARCH_STRING).toList();
    }

    @Override
    protected List<String> visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return ImmutableList.of();
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
        idsCollector._inheritedMembersEntityIds.addAll(ids.entities());
    }
}

