/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.Optional;
import de.justsoftware.onx.common.shared.model.IEntityVersion;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.util.EntityVersionUtil;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.person.shared.server.model.StartpageItem;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractRootBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.data.SolrDataLoader;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import java.util.Date;

final class ExpirationDateLoader
extends AbstractRootBasedSolrDataLoader<Optional<? extends Date>> {
    static final SolrDataLoader INSTANCE = new ExpirationDateLoader();

    private ExpirationDateLoader() {
    }

    @Override
    protected void set(JucoSolrInputDocument doc, Optional<? extends Date> value) {
        doc.addField((SearchField)CommonSearchFields.EXPIRATION_DATE, value);
    }

    @Override
    protected Optional<? extends Date> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem entityItem, Item<?> item) {
        Optional optionalEntityVersion = (Optional)preloadedData._entityVersions.get(entityItem.getId());
        if (!optionalEntityVersion.isPresent()) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)EntityVersionUtil.expirationDate((IEntityVersion)optionalEntityVersion.get()));
    }

    @Override
    protected Optional<Date> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, ProfileItem profile, Item<?> item) {
        return Optional.absent();
    }

    @Override
    protected Optional<? extends Date> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, StartpageItem startPageItem, Item<?> item) {
        return Optional.absent();
    }

    @Override
    protected Optional<Date> visitNonRootItem(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> nonRootItem, Item<?> item) {
        return Optional.absent();
    }

    @Override
    protected Optional<? extends Date> visitUnsupportedRootItem(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> rootItem, Item<?> item) {
        return Optional.absent();
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
        idsCollector._entityVersions.addAll(ids.rootEntities());
    }
}

