/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.Optional;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;

final class EntityFacetAssigneeLoader
extends AbstractItemBasedSolrDataLoader<Optional<Long>> {
    static final EntityFacetAssigneeLoader INSTANCE = new EntityFacetAssigneeLoader();

    private EntityFacetAssigneeLoader() {
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
    }

    @Override
    protected Optional<Long> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem item) {
        PersonId assignee = item.getEntity().getAssignee();
        if (assignee == null) {
            return Optional.absent();
        }
        return Optional.of((Object)assignee.idAsLongValue());
    }

    @Override
    protected Optional<Long> visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return Optional.absent();
    }

    @Override
    protected void set(JucoSolrInputDocument doc, Optional<Long> value) {
        doc.addField((SearchField)CommonSearchFields.ENTITY_FACET_ASSIGNEE, value);
    }
}

