/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.person.shared.server.model.StartpageItem;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractRootBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import java.util.Collection;
import java.util.stream.Stream;

final class DirectParentEntitiesLoader
extends AbstractRootBasedSolrDataLoader<ImmutableSet<String>> {
    static final DirectParentEntitiesLoader INSTANCE = new DirectParentEntitiesLoader();

    private DirectParentEntitiesLoader() {
    }

    @Override
    protected void set(JucoSolrInputDocument doc, ImmutableSet<String> value) {
        doc.addField((SearchField)CommonSearchFields.DIRECT_PARENT_IDS, (Iterable<?>)value);
    }

    @Override
    protected ImmutableSet<String> visitNonRootItem(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> nonRootItem, Item<?> item) {
        return ImmutableSet.of();
    }

    @Override
    protected ImmutableSet<String> visitUnsupportedRootItem(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> rootItem, Item<?> item) {
        return ImmutableSet.of();
    }

    @Override
    protected ImmutableSet<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem entityItem, Item<?> item) {
        EntityId entityId = entityItem.getId();
        Stream<EntityId> parents = !(item instanceof EntityItem) ? Stream.of(entityId) : entityItem.getEntity().getLinkedEntityIds().stream();
        return (ImmutableSet)parents.map(ItemId::asString).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    protected ImmutableSet<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, ProfileItem profileItem, Item<?> item) {
        ProfileId profileId = profileItem.getId();
        if (!profileId.equals(item.getId())) {
            return ImmutableSet.of();
        }
        Collection userEntityIds = (Collection)preloadedData._personMemberships.get(profileId.asPersonId());
        return FluentIterable.from((Iterable)userEntityIds).transform(ItemId::asString).toSet();
    }

    @Override
    protected ImmutableSet<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, StartpageItem startPageItem, Item<?> item) {
        return ImmutableSet.of();
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
        idsCollector._personMembershipPersonIds.addAll(ids.persons());
    }
}

