/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.chat.model.ChatItem;
import de.justsoftware.onx.comments.shared.model.db.DBComment;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.AbstractSearchableItemVisitor;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.NewsChannelItem;
import de.justsoftware.onx.container.shared.server.model.NewsPostItem;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.wiki.model.ArticleItem;
import de.justsoftware.onx.wiki.model.ChapterItem;
import de.justsoftware.onx.wiki.model.WikiItem;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;
import de.justsoftware.polls.model.pollid.item.PollItem;
import java.util.Collection;
import javax.annotation.Nonnull;

final class CommentVisitor
extends AbstractSearchableItemVisitor<Collection<DBComment>> {
    private final SearchDataServiceImpl.SearchPreloadedData _preloaded;

    CommentVisitor(@Nonnull SearchDataServiceImpl.SearchPreloadedData preloadedData) {
        this._preloaded = preloadedData;
    }

    @Override
    public Collection<DBComment> visit(EntityItem item) {
        return this.hasNoComments();
    }

    @Nonnull
    private Collection<DBComment> hasNoComments() {
        return ImmutableList.of();
    }

    @Nonnull
    private Collection<DBComment> hasComment(@Nonnull Item<? extends GlobalId> item) {
        return (Collection)this._preloaded._allComments.get((ItemId)item.getId());
    }

    @Override
    public Collection<DBComment> visit(ProfileItem item) {
        return this.hasNoComments();
    }

    @Override
    public Collection<DBComment> visit(WorkstreamItem item) {
        return this.hasComment(item);
    }

    @Override
    public Collection<DBComment> visit(ChatItem chat) {
        return this.hasNoComments();
    }

    @Override
    public Collection<DBComment> visit(WikiItem wiki) {
        return this.hasNoComments();
    }

    @Override
    public Collection<DBComment> visit(ChapterItem chapter) {
        return this.hasNoComments();
    }

    @Override
    public Collection<DBComment> visit(ArticleItem article) {
        return this.hasNoComments();
    }

    @Override
    public Collection<DBComment> visit(PollItem pollItem) {
        return this.hasNoComments();
    }

    @Override
    public Collection<DBComment> visit(NewsPostItem newsPostItem) {
        return this.hasNoComments();
    }

    @Override
    public Collection<DBComment> visit(NewsChannelItem newsChannelItem) {
        return this.hasNoComments();
    }

    @Override
    protected Collection<DBComment> visitNotSearchableItem(Item<?> item) {
        return this.hasNoComments();
    }

    @Override
    public Collection<DBComment> visit(DriveDocumentItem driveDocumentItem) {
        return this.hasNoComments();
    }

    public static void collectIds(@Nonnull SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, @Nonnull ItemsAndRootParents ids) {
        idsCollector._allCommentsParentIdsItemIds.addAll(ids.workstreamMessageIds());
    }
}

