/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.common.business.InternalLinkService;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractItemBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.data.UrlLinksAndLabels;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.attachments.Attachment;
import de.justsoftware.onx.workstream.shared.model.attachments.AttachmentVisitor;
import de.justsoftware.onx.workstream.shared.model.attachments.DriveDocumentAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.ExternalLinkAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.ImageAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.InternalLinkAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.LinkAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.MailToLinkAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.PollAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.VideoLinkAttachment;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

final class AttachmentUrlsLoader
extends AbstractItemBasedSolrDataLoader<UrlLinksAndLabels> {
    static final AttachmentUrlsLoader INSTANCE = new AttachmentUrlsLoader();

    private AttachmentUrlsLoader() {
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
        idsCollector._attachmentWorkstreamMessageIds.addAll(ids.workstreamMessageIds());
    }

    @Override
    protected UrlLinksAndLabels visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, WorkstreamItem item) {
        Collection attachments = (Collection)preloadedData._attachments.get((WorkstreamMessageId)item.getId());
        if (attachments.isEmpty()) {
            return UrlLinksAndLabels.EMPTY;
        }
        AttachmentSearchIndexingVisitor visitor = new AttachmentSearchIndexingVisitor(preloadedData);
        for (Attachment attachment : attachments) {
            attachment.accept(visitor);
        }
        return new UrlLinksAndLabels((ImmutableSet<String>)visitor._urlLinks.build(), (ImmutableSet<String>)visitor._urlLabels.build());
    }

    @Override
    protected UrlLinksAndLabels visitDefault(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item) {
        return UrlLinksAndLabels.EMPTY;
    }

    @Override
    protected void set(JucoSolrInputDocument doc, UrlLinksAndLabels value) {
        doc.addField((SearchField)CommonSearchFields.URL_LINKS, (Iterable<?>)value._urlLinks);
        doc.addField((SearchField)CommonSearchFields.URL_LABELS, (Iterable<?>)value._urlLabels);
    }

    private static final class AttachmentSearchIndexingVisitor
    implements AttachmentVisitor<Attachment> {
        private final SearchDataServiceImpl.SearchPreloadedData _preloadedData;
        private final ImmutableSet.Builder<String> _urlLabels = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> _urlLinks = ImmutableSet.builder();

        public AttachmentSearchIndexingVisitor(@Nonnull SearchDataServiceImpl.SearchPreloadedData preloadedData) {
            this._preloadedData = preloadedData;
        }

        @Override
        public ImageAttachment visit(ImageAttachment attachment) {
            AlbumImageId id = attachment.getId();
            if (id == null) {
                return attachment;
            }
            this.addLink(this._preloadedData.internalLinkService().getImageUrl(id, InternalLinkService.LinkType.FRAGMENT));
            this.addLabel(attachment.getTitle());
            return attachment;
        }

        @Override
        public LinkAttachment visit(InternalLinkAttachment linkAttachment) {
            return this.visitLinkAttachment(linkAttachment);
        }

        @Override
        public LinkAttachment visit(ExternalLinkAttachment linkAttachment) {
            return this.visitLinkAttachment(linkAttachment);
        }

        @Override
        public Attachment visit(MailToLinkAttachment mailToLinkAttachment) {
            return this.visitLinkAttachment(mailToLinkAttachment);
        }

        @Nonnull
        private LinkAttachment visitLinkAttachment(@Nonnull LinkAttachment linkAttachment) {
            this.addLabel(linkAttachment.getRawTitle());
            this.addLink(linkAttachment.getUrl());
            return linkAttachment;
        }

        @Override
        public VideoLinkAttachment visit(VideoLinkAttachment videoLinkAttachment) {
            VideolinkId id = videoLinkAttachment.getId();
            if (id != null) {
                this.addLink(this._preloadedData.internalLinkService().getVideoUrl(id, InternalLinkService.LinkType.FRAGMENT));
                this.addLabel(videoLinkAttachment.getVideolink().getTitle());
            }
            return videoLinkAttachment;
        }

        @Override
        public Attachment visit(DriveDocumentAttachment attachment) {
            this.addLabel(attachment.getName());
            DriveDocumentId driveId = attachment.getId();
            if (driveId != null) {
                this.addLink(this._preloadedData.internalLinkService().getDriveDocumentUrl(driveId, InternalLinkService.LinkType.FRAGMENT));
            }
            return attachment;
        }

        @Override
        public Attachment visit(PollAttachment pollAttachment) {
            return pollAttachment;
        }

        private void addLink(String link) {
            if (StringUtils.isNotBlank((String)link)) {
                this._urlLinks.add((Object)link);
            }
        }

        private void addLabel(@Nullable String label) {
            if (StringUtils.isNotBlank((String)label)) {
                this._urlLabels.add((Object)label);
            }
        }
    }
}

