/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.base.Functions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.person.shared.server.model.StartpageItem;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.data.AbstractRootBasedSolrDataLoader;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import java.util.Collection;
import java.util.List;
import java.util.Map;

final class AllParentEntitiesLoader
extends AbstractRootBasedSolrDataLoader<List<String>> {
    static final AllParentEntitiesLoader INSTANCE = new AllParentEntitiesLoader();

    private AllParentEntitiesLoader() {
    }

    @Override
    protected void set(JucoSolrInputDocument doc, List<String> value) {
        doc.addField((SearchField)CommonSearchFields.PARENT_IDS, value);
    }

    @Override
    protected List<String> visitNonRootItem(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> nonRootItem, Item<?> item) {
        return ImmutableList.of();
    }

    @Override
    protected ImmutableList<String> visitUnsupportedRootItem(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> rootItem, Item<?> item) {
        return ImmutableList.of();
    }

    @Override
    public List<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, EntityItem entityItem, Item<?> item) {
        EntityId entityId = entityItem.getId();
        FluentIterable allParents = FluentIterable.from((Iterable)((Iterable)preloadedData._allEntityParents.get(entityId)));
        if (!(item instanceof EntityItem)) {
            allParents = allParents.append((Object[])new EntityId[]{entityId});
        }
        return allParents.transform(ItemId::asString).toSet().asList();
    }

    @Override
    public List<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, ProfileItem profileItem, Item<?> item) {
        ProfileId profileId = profileItem.getId();
        if (!profileId.equals(item.getId())) {
            return ImmutableList.of();
        }
        Collection userEntityIds = (Collection)preloadedData._personMemberships.get(profileId.asPersonId());
        return FluentIterable.from((Iterable)userEntityIds).transformAndConcat(Functions.forMap((Map)preloadedData._allEntityParents._map, (Object)ImmutableSet.of())).append((Iterable)userEntityIds).transform(ItemId::asString).toSet().asList();
    }

    @Override
    protected boolean indexDriveAllowed() {
        return true;
    }

    @Override
    public List<String> visit(SearchDataServiceImpl.SearchPreloadedData preloadedData, StartpageItem startpageItem, Item<?> item) {
        return ImmutableList.of();
    }

    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
        idsCollector._allEntityParentsRootEntities.addAll(ids.rootEntities());
        idsCollector._personMembershipPersonIds.addAll(ids.persons());
    }
}

