/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.data;

import com.google.common.collect.ImmutableCollection;
import de.justsoftware.onx.chat.model.ChatItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.container.shared.server.model.NewsPostItem;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.searchnew.business.data.ItemsAndRootParents;
import de.justsoftware.onx.searchnew.business.data.SearchDataServiceImpl;
import de.justsoftware.onx.searchnew.business.data.SolrDataLoader;
import de.justsoftware.onx.searchnew.business.impl.JucoSolrInputDocument;
import de.justsoftware.onx.wiki.model.ArticleItem;
import de.justsoftware.onx.wiki.model.ChapterItem;
import de.justsoftware.onx.wiki.model.WikiItem;
import de.justsoftware.polls.model.pollid.item.PollItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;

@ParametersAreNonnullByDefault
public abstract class AbstractSolrDataLoader<T>
implements SolrDataLoader {
    @Override
    public void collectIds(SearchDataServiceImpl.SearchPreloadedDataIdCollector idsCollector, ItemsAndRootParents ids) {
    }

    public final boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass().equals(obj.getClass());
    }

    public final int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public final String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public final void set(SearchDataServiceImpl.SearchPreloadedData preloadedData, Item<?> item, Item<?> rootParent, JucoSolrInputDocument doc) {
        Boolean allowed = item.accept(new ItemVisitor.DefaultItemVisitor<Boolean>(){

            @Override
            protected Boolean visitDefault(Item<?> i) {
                return Boolean.TRUE;
            }

            @Override
            public Boolean visit(DriveDocumentItem driveDocumentItem) {
                return AbstractSolrDataLoader.this.indexDriveAllowed();
            }

            @Override
            public Boolean visit(ChatItem chatItem) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visit(WikiItem wikiItem) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visit(ChapterItem chapterItem) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visit(ArticleItem articleItem) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visit(PollItem pollItem) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visit(NewsPostItem newsPostItem) {
                return Boolean.FALSE;
            }
        });
        if (allowed.booleanValue()) {
            this.set(doc, this.getValue(preloadedData, item, rootParent));
        }
    }

    protected boolean indexDriveAllowed() {
        return false;
    }

    protected static void addNonEmpty(ImmutableCollection.Builder<String> builder, @Nullable String s) {
        if (StringUtils.isNotBlank((String)s)) {
            builder.add((Object)s);
        }
    }

    @Nonnull
    protected abstract T getValue(SearchDataServiceImpl.SearchPreloadedData var1, Item<?> var2, Item<?> var3);

    protected abstract void set(JucoSolrInputDocument var1, T var2);
}

