/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.criteria;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.searchnew.business.criteria.AndExpression;
import de.justsoftware.onx.searchnew.business.criteria.Criterion;
import de.justsoftware.onx.searchnew.business.criteria.EqExpression;
import de.justsoftware.onx.searchnew.business.criteria.LocalParam;
import de.justsoftware.onx.searchnew.business.criteria.LocalParamCriterion;
import de.justsoftware.onx.searchnew.business.criteria.MandatoryExpression;
import de.justsoftware.onx.searchnew.business.criteria.NotExpression;
import de.justsoftware.onx.searchnew.business.criteria.OrExpression;
import de.justsoftware.onx.searchnew.business.criteria.ProhibitedExpression;
import de.justsoftware.onx.searchnew.business.criteria.RangeExpression;
import de.justsoftware.onx.searchnew.business.criteria.UnaryNotExpression;
import de.justsoftware.onx.searchnew.business.criteria.WhitespaceOperandExpression;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Restrictions {
    public static <T> RangeExpression<T> range(String fieldName, T minValue, T maxValue) {
        return new RangeExpression<T>(fieldName, minValue, maxValue);
    }

    public static <T> EqExpression<T> eq(String fieldName, T value) {
        return new EqExpression<T>(fieldName, value);
    }

    public static <T> EqExpression<T> eq(String fieldName, T value, Float boosting) {
        return new EqExpression<T>(fieldName, value, boosting);
    }

    @Nonnull
    public static <T, U> Criterion eq(@Nonnull String fieldName, @Nonnull Iterable<T> values, @Nonnull Function<? super T, U> getValueFunction) {
        OrExpression or = Restrictions.or(new Criterion[0]);
        for (T value : values) {
            or.add(Restrictions.eq(fieldName, getValueFunction.apply(value)));
        }
        return or;
    }

    @Nonnull
    public static <T, U> Criterion neq(@Nonnull String fieldName, @Nullable Iterable<T> values, @Nonnull Function<? super T, U> getValueFunction) {
        AndExpression and = Restrictions.and();
        if (values != null) {
            for (T value : values) {
                and.add(Restrictions.prohibited(fieldName, getValueFunction.apply(value)));
            }
        }
        return and;
    }

    public static <T> MandatoryExpression<T> mandatory(String fieldName, T value) {
        return new MandatoryExpression<T>(fieldName, value);
    }

    public static <T> ProhibitedExpression<T> prohibited(String fieldName, T value) {
        return new ProhibitedExpression<T>(fieldName, value);
    }

    public static AndExpression and() {
        return new AndExpression();
    }

    @Nonnull
    public static AndExpression and(@Nonnull Criterion criterion1, @Nonnull Criterion criterion2) {
        AndExpression result = Restrictions.and();
        result.add(criterion1);
        result.add(criterion2);
        return result;
    }

    public static Criterion and(@Nonnull Iterable<Criterion> criteria) {
        if (Iterables.isEmpty(criteria)) {
            throw new IllegalArgumentException("criteria must contain at least one element");
        }
        if (Iterables.size(criteria) == 1) {
            return criteria.iterator().next();
        }
        AndExpression result = Restrictions.and();
        for (Criterion criterion : criteria) {
            result.add(criterion);
        }
        return result;
    }

    @Nonnull
    public static OrExpression or(Criterion ... criterions) {
        OrExpression result = new OrExpression();
        for (Criterion criterion : criterions) {
            result.add(criterion);
        }
        return result;
    }

    @Nonnull
    public static OrExpression or(@Nonnull Iterable<Criterion> criterions) {
        OrExpression result = new OrExpression();
        for (Criterion criterion : criterions) {
            result.add(criterion);
        }
        return result;
    }

    @Nonnull
    public static UnaryNotExpression not(@Nonnull Criterion criterion) {
        return new UnaryNotExpression(criterion);
    }

    @Nonnull
    public static NotExpression not(@Nonnull String field, @Nonnull Set<String> values) {
        NotExpression result = new NotExpression();
        result.add(Restrictions.eq(field, "*"));
        for (String value : values) {
            if (Strings.isNullOrEmpty((String)value)) continue;
            result.add(Restrictions.eq(field, value));
        }
        return result;
    }

    public static WhitespaceOperandExpression whitespaceOperand() {
        return new WhitespaceOperandExpression();
    }

    public static WhitespaceOperandExpression whitespaceOperand(Criterion criterion1, Criterion criterion2) {
        WhitespaceOperandExpression result = Restrictions.whitespaceOperand();
        result.add(criterion1);
        result.add(criterion2);
        return result;
    }

    public static LocalParamCriterion localParams(LocalParam localParam, Criterion criterion, boolean inlineValueParameter) {
        return new LocalParamCriterion(localParam, criterion, inlineValueParameter);
    }
}

